/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Arrays;
import java.util.function.IntPredicate;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Slice16;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Twine16
extends UnicodeString {
    protected char[] chars;
    protected int cachedHash = 0;

    protected Twine16(char[] chars) {
        this.chars = chars;
    }

    public Twine16(char[] chars, int start, int len) {
        if (start == 0) {
            this.chars = Arrays.copyOf(chars, len);
        } else {
            this.chars = new char[len];
            System.arraycopy(chars, start, this.chars, 0, len);
        }
    }

    public char[] getCharArray() {
        return this.chars;
    }

    @Override
    public long length() {
        return this.chars.length;
    }

    @Override
    public int length32() {
        return this.chars.length;
    }

    @Override
    public UnicodeString substring(long start, long end) {
        int start32 = Twine16.requireInt(start);
        int end32 = Twine16.requireInt(end);
        int len = this.length32();
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        if (start == 0L && end == (long)len) {
            return this;
        }
        return new Slice16(this.chars, start32, end32);
    }

    @Override
    public int codePointAt(long index) throws IndexOutOfBoundsException {
        int index32 = Twine16.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[index32];
    }

    @Override
    public long indexOf(int codePoint, long from) {
        if (codePoint < 0 || codePoint > 65535) {
            return -1L;
        }
        int from32 = Twine16.requireNonNegativeInt(from);
        int last = this.chars.length;
        for (int i2 = from32; i2 < last; ++i2) {
            if (this.chars[i2] != codePoint) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long indexOf(UnicodeString other, long from) {
        int from32 = Twine16.requireInt(from);
        if (from32 < 0) {
            from32 = 0;
        } else if (from32 >= this.length32()) {
            return -1L;
        }
        if (other.isEmpty()) {
            return from;
        }
        int initial = other.codePointAt(0L);
        int len = Twine16.requireInt(other.length());
        int lastPossible = this.length32() - len;
        while (from32 <= lastPossible) {
            int i2 = Twine16.requireInt(this.indexOf(initial, (long)from32));
            if (i2 < 0) {
                return -1L;
            }
            if (this.hasSubstring(other, i2)) {
                return i2;
            }
            from32 = i2 + 1;
        }
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.chars.length == 0;
    }

    @Override
    void copy16bit(char[] target, int offset) {
        System.arraycopy(this.chars, 0, target, offset, this.chars.length);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        int i2 = 0;
        int j = offset;
        while (i2 < this.chars.length) {
            char c = this.chars[i2++];
            target[j++] = 0;
            target[j++] = (byte)(c >> 8);
            target[j++] = (byte)(c & 0xFF);
        }
    }

    @Override
    void copy32bit(int[] target, int offset) {
        int i2 = 0;
        int j = offset;
        while (i2 < this.chars.length) {
            target[j++] = this.chars[i2++];
        }
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Twine16.this.chars.length;
            }

            @Override
            public int next() {
                return Twine16.this.chars[this.i++];
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h = 0;
        for (char cp : this.chars) {
            h = 31 * h + cp;
        }
        this.cachedHash = h;
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Twine16) {
            return Arrays.equals(this.chars, ((Twine16)o).chars);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (other instanceof Twine16) {
            Twine16 o = (Twine16)other;
            char[] a = this.chars;
            char[] b = o.chars;
            int len = Math.min(a.length, b.length);
            for (int i2 = 0; i2 < len; ++i2) {
                int diff = a[i2] - b[i2];
                if (diff == 0) continue;
                return diff;
            }
            return Long.compare(this.length(), o.length());
        }
        return super.compareTo(other);
    }

    public String toString() {
        return new String(this.chars);
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        int i2 = Twine16.requireNonNegativeInt(from);
        while ((long)i2 < this.length()) {
            if (predicate.test(this.chars[i2])) {
                return i2;
            }
            ++i2;
        }
        return -1L;
    }

    public String details() {
        return "Twine16 length = " + this.chars.length;
    }
}

