/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchHeaderException
extends CamelExchangeException {
    private final String headerName;
    private final transient Class<?> type;

    public NoSuchHeaderException(String message, Exchange exchange2, String headerName) {
        super(message, exchange2);
        this.headerName = headerName;
        this.type = null;
    }

    public NoSuchHeaderException(Exchange exchange2, String headerName, Class<?> type) {
        super("No '" + headerName + "' header available" + (String)(type != null ? " of type: " + type.getName() : "") + NoSuchHeaderException.reason(exchange2, headerName), exchange2);
        this.headerName = headerName;
        this.type = type;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange2, String headerName) {
        Object value = exchange2.getMessage().getHeader(headerName);
        return NoSuchHeaderException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has value: " + String.valueOf(value) + " of type: " + value.getClass().getCanonicalName();
    }
}

