/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.AdviceIterator;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.SharedInternalProcessor;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCamelInternalProcessor
implements SharedInternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedCamelInternalProcessor.class);
    private final ReactiveExecutor reactiveExecutor;
    private final AsyncProcessorAwaitManager awaitManager;
    private final ShutdownStrategy shutdownStrategy;
    private final CamelInternalProcessorAdvice<?> advice;

    public SharedCamelInternalProcessor(CamelContext camelContext, CamelInternalProcessorAdvice<?> advice) {
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.awaitManager = PluginHelper.getAsyncProcessorAwaitManager(camelContext);
        this.shutdownStrategy = camelContext.getShutdownStrategy();
        this.advice = Objects.requireNonNull(advice, "advice");
    }

    @Override
    public void process(Exchange exchange2, final AsyncProcessor processor, final Processor resultProcessor) {
        this.awaitManager.process(new AsyncProcessor(){

            @Override
            public boolean process(Exchange exchange2, AsyncCallback callback) {
                return SharedCamelInternalProcessor.this.process(exchange2, callback, processor, resultProcessor);
            }

            @Override
            public CompletableFuture<Exchange> processAsync(Exchange exchange2) {
                AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange2);
                this.process(exchange2, callback);
                return callback.getFuture();
            }

            @Override
            public void process(Exchange exchange2) throws Exception {
                throw new IllegalStateException();
            }
        }, exchange2);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback originalCallback, AsyncProcessor processor, Processor resultProcessor) {
        Object state;
        if (processor == null || !this.continueProcessing(exchange2)) {
            originalCallback.done(true);
            return true;
        }
        try {
            state = this.advice.before(exchange2);
        }
        catch (Exception e) {
            return SharedCamelInternalProcessor.handleException(exchange2, originalCallback, e);
        }
        InternalCallback callback = new InternalCallback(state, exchange2, originalCallback, resultProcessor);
        if (exchange2.isTransacted()) {
            return SharedCamelInternalProcessor.processTransacted(exchange2, processor, callback);
        }
        return SharedCamelInternalProcessor.processNonTransacted(exchange2, processor, callback);
    }

    private static boolean handleException(Exchange exchange2, AsyncCallback originalCallback, Exception e) {
        exchange2.setException(e);
        originalCallback.done(true);
        return true;
    }

    private static boolean processNonTransacted(Exchange exchange2, AsyncProcessor processor, AsyncCallback callback) {
        UnitOfWork uow = exchange2.getUnitOfWork();
        AsyncCallback async = callback;
        boolean beforeAndAfter = uow.isBeforeAfterProcess();
        if (beforeAndAfter) {
            async = uow.beforeProcess(processor, exchange2, async);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange2.getExchangeId(), (Object)exchange2);
        }
        boolean sync = processor.process(exchange2, async);
        if (beforeAndAfter) {
            uow.afterProcess(processor, exchange2, callback, sync);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", new Object[]{sync ? "synchronously" : "asynchronously", exchange2.getExchangeId(), exchange2});
        }
        return sync;
    }

    private static boolean processTransacted(Exchange exchange2, AsyncProcessor processor, AsyncCallback callback) {
        if (LOG.isTraceEnabled()) {
            if (exchange2.isTransacted()) {
                LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange2.getExchangeId(), (Object)exchange2);
            } else {
                LOG.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange2.getExchangeId(), (Object)exchange2);
            }
        }
        try {
            processor.process(exchange2);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    protected boolean continueProcessing(Exchange exchange2) {
        if (exchange2.isRouteStop()) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange2);
            return false;
        }
        if (this.shutdownStrategy.isForceShutdown()) {
            if (LOG.isDebugEnabled() || exchange2.getException() == null) {
                String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + String.valueOf(exchange2);
                LOG.debug(msg);
                if (exchange2.getException() == null) {
                    exchange2.setException(new RejectedExecutionException(msg));
                }
            }
            return false;
        }
        return true;
    }

    private final class InternalCallback
    implements AsyncCallback {
        private final Object state;
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Processor resultProcessor;

        private InternalCallback(Object state, Exchange exchange2, AsyncCallback callback, Processor resultProcessor) {
            this.state = state;
            this.exchange = exchange2;
            this.callback = callback;
            this.resultProcessor = resultProcessor;
        }

        @Override
        public void done(boolean doneSync) {
            if (this.resultProcessor != null) {
                try {
                    this.resultProcessor.process(this.exchange);
                }
                catch (Exception e) {
                    this.exchange.setException(e);
                }
            }
            try {
                AdviceIterator.runAfterTask(SharedCamelInternalProcessor.this.advice, this.state, this.exchange);
            }
            finally {
                if (this.callback != null) {
                    SharedCamelInternalProcessor.this.reactiveExecutor.schedule(this.callback);
                }
            }
        }
    }
}

