/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.language.spel.RootObject;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.apache.camel.support.ExpressionSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final BeanResolver beanResolver;
    private final SpelExpressionParser expressionParser;
    private volatile Expression expression;

    public SpelExpression(String expressionString, Class<?> type) {
        this(expressionString, type, null);
    }

    public SpelExpression(String expressionString, Class<?> type, BeanResolver beanResolver) {
        this.expressionString = expressionString;
        this.type = type;
        this.beanResolver = beanResolver;
        this.expressionParser = new SpelExpressionParser();
    }

    public static SpelExpression spel(String expression) {
        return new SpelExpression(expression, Object.class);
    }

    @Override
    public <T> T evaluate(Exchange exchange2, Class<T> tClass) {
        if (this.expression == null) {
            this.init(exchange2.getContext());
        }
        try {
            EvaluationContext evaluationContext = this.createEvaluationContext(exchange2);
            Object value = this.expression.getValue(evaluationContext);
            return exchange2.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this, exchange2, e);
        }
    }

    private EvaluationContext createEvaluationContext(Exchange exchange2) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(new RootObject(exchange2));
        evaluationContext.addPropertyAccessor(new MapAccessor());
        if (this.beanResolver != null) {
            evaluationContext.setBeanResolver(this.beanResolver);
        } else if (exchange2.getContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)exchange2.getContext()).getApplicationContext();
            evaluationContext.setBeanResolver(new BeanFactoryResolver(applicationContext));
        } else {
            evaluationContext.setBeanResolver(new RegistryBeanResolver(exchange2.getContext().getRegistry()));
        }
        return evaluationContext;
    }

    private Expression parseExpression() {
        TemplateParserContext parserContext = new TemplateParserContext();
        return this.expressionParser.parseExpression(this.expressionString, parserContext);
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange2) {
        return this.expressionString;
    }

    @Override
    public void init(CamelContext context) {
        this.expression = this.parseExpression();
    }

    public String toString() {
        return "SpelExpression[" + this.expressionString + "]";
    }
}

