/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FilterProcessor.class);
    private final CamelContext context;
    private String id;
    private String routeId;
    private final Predicate predicate;
    private transient long filtered;
    private String statusPropertyName;

    public FilterProcessor(CamelContext context, Predicate predicate, Processor processor) {
        super(processor);
        this.context = context;
        this.predicate = predicate;
    }

    public String getStatusPropertyName() {
        return this.statusPropertyName;
    }

    public void setStatusPropertyName(String statusPropertyName) {
        this.statusPropertyName = statusPropertyName;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.predicate.init(this.context);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        boolean matches = false;
        try {
            matches = this.matches(exchange2);
            if (this.statusPropertyName != null) {
                exchange2.setProperty(this.statusPropertyName, (Object)matches);
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        if (matches) {
            return this.processor.process(exchange2, callback);
        }
        callback.done(true);
        return true;
    }

    public boolean matches(Exchange exchange2) {
        boolean matches = this.predicate.matches(exchange2);
        LOG.debug("Filter matches: {} for exchange: {}", (Object)matches, (Object)exchange2);
        if (matches) {
            ++this.filtered;
        }
        return matches;
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String getTraceLabel() {
        return "filter[if: " + String.valueOf(this.predicate) + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public long getFilteredCount() {
        return this.filtered;
    }

    public void reset() {
        this.filtered = 0L;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.reset();
        ServiceHelper.startService((Object)this.predicate);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.predicate);
        super.doStop();
    }
}

