/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Predicate;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpointProcessor
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpointProcessor.class);
    private final InterceptSendToEndpoint endpoint;
    private final Endpoint delegate;
    private final AsyncProducer producer;
    private final boolean skip;
    private AsyncProcessor pipeline;

    public InterceptSendToEndpointProcessor(InterceptSendToEndpoint endpoint, Endpoint delegate, AsyncProducer producer, boolean skip) {
        super(delegate);
        this.endpoint = endpoint;
        this.delegate = delegate;
        this.producer = producer;
        this.skip = skip;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), this.endpoint.getBefore(), exchange2});
        }
        exchange2.setProperty(ExchangePropertyKey.INTERCEPTED_ENDPOINT, (Object)this.delegate.getEndpointUri());
        if (this.pipeline != null) {
            return this.pipeline.process(exchange2, callback);
        }
        return this.callback(exchange2, callback, true);
    }

    private boolean callback(Exchange exchange2, AsyncCallback callback, boolean doneSync) {
        if (!PipelineHelper.continueProcessing(exchange2, "skip sending to original intended destination: " + String.valueOf(this.getEndpoint()), LOG)) {
            callback.done(doneSync);
            return doneSync;
        }
        boolean shouldSkip = this.skip;
        Boolean whenMatches = this.endpoint.getAfter() != null ? (Boolean)exchange2.getProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED) : (Boolean)exchange2.removeProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
        if (whenMatches != null) {
            boolean bl = shouldSkip = this.skip && whenMatches != false;
        }
        if (!shouldSkip) {
            ExchangeHelper.prepareOutToIn(exchange2);
            boolean s = this.producer.process(exchange2, ds -> callback.done(doneSync && ds));
            return doneSync && s;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stop() means skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange2);
        }
        callback.done(doneSync);
        return doneSync;
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    @Override
    protected void doBuild() throws Exception {
        CamelContextAware.trySetCamelContext(this.producer, this.endpoint.getCamelContext());
        if (this.endpoint.getBefore() != null || this.endpoint.getAfter() != null) {
            AsyncProcessor before = null;
            if (this.endpoint.getBefore() != null) {
                before = AsyncProcessorConverterHelper.convert(this.endpoint.getBefore());
            }
            AsyncProcessorSupport ascb = new AsyncProcessorSupport(){

                @Override
                public boolean process(Exchange exchange2, AsyncCallback callback) {
                    return InterceptSendToEndpointProcessor.this.callback(exchange2, callback, true);
                }
            };
            FilterProcessor filter2 = this.createFilterProcessor();
            this.pipeline = new Pipeline(this.getEndpoint().getCamelContext(), Arrays.asList(before, ascb, filter2));
        }
        ServiceHelper.buildService(this.producer, this.pipeline);
    }

    private FilterProcessor createFilterProcessor() {
        Predicate predicate = exchange2 -> {
            Boolean whenMatches = (Boolean)exchange2.removeProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
            return whenMatches == null || whenMatches != false;
        };
        AsyncProcessor after = null;
        if (this.endpoint.getAfter() != null) {
            after = AsyncProcessorConverterHelper.convert(this.endpoint.getAfter());
        }
        return new FilterProcessor(this.getEndpoint().getCamelContext(), predicate, after);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService(this.producer, this.pipeline);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.producer, this.pipeline);
    }

    @Override
    public void doStop() {
        ServiceHelper.stopService(this.producer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producer, this.pipeline);
    }
}

