/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.processor.PooledExchangeTask;
import org.apache.camel.processor.PooledExchangeTaskFactory;
import org.apache.camel.support.PooledObjectFactorySupport;

public abstract class PooledTaskFactory
extends PooledObjectFactorySupport<PooledExchangeTask>
implements PooledExchangeTaskFactory {
    public PooledTaskFactory() {
    }

    public PooledTaskFactory(Object source) {
        super(source);
    }

    @Override
    public PooledExchangeTask acquire() {
        return (PooledExchangeTask)this.pool.poll();
    }

    @Override
    public PooledExchangeTask acquire(Exchange exchange2, AsyncCallback callback) {
        PooledExchangeTask task = this.acquire();
        if (task == null) {
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
            task = this.create(exchange2, callback);
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        try {
            task.prepare(exchange2, callback);
        }
        catch (Exception e) {
            if (this.statisticsEnabled) {
                this.statistics.discarded.increment();
            }
            throw e;
        }
        return task;
    }

    @Override
    public boolean release(PooledExchangeTask task) {
        try {
            task.reset();
            boolean inserted = this.pool.offer(task);
            if (this.statisticsEnabled) {
                if (inserted) {
                    this.statistics.released.increment();
                } else {
                    this.statistics.discarded.increment();
                }
            }
            return inserted;
        }
        catch (Exception e) {
            if (this.statisticsEnabled) {
                this.statistics.discarded.increment();
            }
            return false;
        }
    }

    public String toString() {
        if (this.source != null) {
            return "PooledTaskFactory[source: " + String.valueOf(this.source) + ", capacity: " + this.getCapacity() + "]";
        }
        return "PooledTaskFactory[capacity: " + this.getCapacity() + "]";
    }
}

