/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamResequencer
extends AsyncProcessorSupport
implements SequenceSender<Exchange>,
Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(StreamResequencer.class);
    private String id;
    private String routeId;
    private final CamelContext camelContext;
    private final ExceptionHandler exceptionHandler;
    private final ResequencerEngine<Exchange> engine;
    private final Processor processor;
    private final Expression expression;
    private Delivery delivery;
    private int capacity;
    private boolean ignoreInvalidExchanges;
    private long deliveryAttemptInterval = 1000L;

    public StreamResequencer(CamelContext camelContext, Processor processor, SequenceElementComparator<Exchange> comparator, Expression expression) {
        ObjectHelper.notNull(camelContext, "CamelContext");
        this.camelContext = camelContext;
        this.engine = new ResequencerEngine<Exchange>(comparator);
        this.engine.setSequenceSender(this);
        this.processor = processor;
        this.expression = expression;
        this.exceptionHandler = new LoggingExceptionHandler(camelContext, this.getClass());
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getTimeout() {
        return this.engine.getTimeout();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public void setDeliveryAttemptInterval(long deliveryAttemptInterval) {
        this.deliveryAttemptInterval = deliveryAttemptInterval;
    }

    public boolean isIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setRejectOld(Boolean rejectOld) {
        this.engine.setRejectOld(rejectOld);
    }

    public boolean isRejectOld() {
        return this.engine.getRejectOld() != null && this.engine.getRejectOld() != false;
    }

    public void setIgnoreInvalidExchanges(boolean ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "streamResequence";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
        this.delivery = new Delivery();
        this.engine.start();
        this.delivery.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.engine.stop();
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    public void sendElement(Exchange exchange2) throws Exception {
        this.processor.process(exchange2);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            this.engine.waitUntil(s -> s.size() < this.capacity);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exchange2.setException(e);
            callback.done(true);
            return true;
        }
        try {
            Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange2, true);
            this.engine.insert(copy);
            this.delivery.request();
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidExchanges()) {
                LOG.debug("Invalid Exchange. This Exchange will be ignored: {}", (Object)exchange2);
            }
            exchange2.setException(new CamelExchangeException("Error processing Exchange in StreamResequencer", exchange2, e));
        }
        callback.done(true);
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    class Delivery
    extends Thread {
        private final Lock deliveryRequestLock;
        private final Condition deliveryRequestCondition;

        Delivery() {
            super(StreamResequencer.this.camelContext.getExecutorServiceManager().resolveThreadName("Resequencer Delivery"));
            this.deliveryRequestLock = new ReentrantLock();
            this.deliveryRequestCondition = this.deliveryRequestLock.newCondition();
        }

        @Override
        public void run() {
            while (StreamResequencer.this.isRunAllowed()) {
                try {
                    this.deliveryRequestLock.lock();
                    try {
                        this.deliveryRequestCondition.await(StreamResequencer.this.deliveryAttemptInterval, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.deliveryRequestLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                try {
                    StreamResequencer.this.engine.deliver();
                }
                catch (Exception t) {
                    StreamResequencer.this.getExceptionHandler().handleException(t);
                }
            }
        }

        public void cancel() {
            this.interrupt();
        }

        public void request() {
            this.deliveryRequestLock.lock();
            try {
                this.deliveryRequestCondition.signal();
            }
            finally {
                this.deliveryRequestLock.unlock();
            }
        }
    }
}

