/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessor;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class RequiredSagaProcessor
extends SagaProcessor {
    public RequiredSagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(camelContext, childProcessor, sagaService, completionMode, step);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        this.getCurrentSagaCoordinator(exchange2).whenComplete((existingCoordinator, ex) -> this.ifNotException((Throwable)ex, exchange2, callback, () -> {
            boolean inheritedCoordinator;
            CompletableFuture<CamelSagaCoordinator> coordinatorFuture;
            if (existingCoordinator != null) {
                coordinatorFuture = CompletableFuture.completedFuture(existingCoordinator);
                inheritedCoordinator = true;
            } else {
                coordinatorFuture = this.sagaService.newSaga(exchange2);
                inheritedCoordinator = false;
            }
            coordinatorFuture.whenComplete((coordinator, ex2) -> this.ifNotException((Throwable)ex2, exchange2, !inheritedCoordinator, (CamelSagaCoordinator)coordinator, (CamelSagaCoordinator)existingCoordinator, callback, () -> {
                this.setCurrentSagaCoordinator(exchange2, (CamelSagaCoordinator)coordinator);
                coordinator.beginStep(exchange2, this.step).whenComplete((done, ex3) -> this.ifNotException((Throwable)ex3, exchange2, !inheritedCoordinator, (CamelSagaCoordinator)coordinator, (CamelSagaCoordinator)existingCoordinator, callback, () -> super.process(exchange2, doneSync -> {
                    if (!inheritedCoordinator) {
                        this.handleSagaCompletion(exchange2, (CamelSagaCoordinator)coordinator, null, callback);
                    } else {
                        callback.done(false);
                    }
                })));
            }));
        }));
        return false;
    }
}

