/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class SagaProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    protected final CamelSagaService sagaService;
    protected final CamelSagaStep step;
    protected final SagaCompletionMode completionMode;
    private String id;
    private String routeId;

    public SagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(ObjectHelper.notNull(childProcessor, "childProcessor"));
        this.sagaService = ObjectHelper.notNull(sagaService, "sagaService");
        this.completionMode = ObjectHelper.notNull(completionMode, "completionMode");
        this.step = ObjectHelper.notNull(step, "step");
    }

    protected CompletableFuture<CamelSagaCoordinator> getCurrentSagaCoordinator(Exchange exchange2) {
        String currentSaga = exchange2.getIn().getHeader("Long-Running-Action", String.class);
        if (currentSaga != null) {
            return this.sagaService.getSaga(currentSaga);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected void setCurrentSagaCoordinator(Exchange exchange2, CamelSagaCoordinator coordinator) {
        if (coordinator != null) {
            exchange2.getIn().setHeader("Long-Running-Action", coordinator.getId());
        } else {
            exchange2.getIn().removeHeader("Long-Running-Action");
            exchange2.getMessage().removeHeader("Long-Running-Action");
        }
    }

    protected void handleSagaCompletion(Exchange exchange2, CamelSagaCoordinator coordinator, CamelSagaCoordinator previousCoordinator, AsyncCallback callback) {
        if (this.completionMode == SagaCompletionMode.AUTO) {
            if (exchange2.getException() != null) {
                if (coordinator != null) {
                    coordinator.compensate(exchange2).whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange2, callback, () -> {
                        this.setCurrentSagaCoordinator(exchange2, previousCoordinator);
                        callback.done(false);
                    }));
                } else {
                    callback.done(false);
                }
            } else {
                coordinator.complete(exchange2).whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange2, callback, () -> {
                    this.setCurrentSagaCoordinator(exchange2, previousCoordinator);
                    callback.done(false);
                }));
            }
        } else if (this.completionMode == SagaCompletionMode.MANUAL) {
            callback.done(false);
        } else {
            throw new IllegalStateException("Unsupported completion mode: " + String.valueOf((Object)this.completionMode));
        }
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String toString() {
        return "id";
    }

    @Override
    public String getTraceLabel() {
        return "saga";
    }

    protected void ifNotException(Throwable ex, Exchange exchange2, AsyncCallback callback, Runnable code) {
        this.ifNotException(ex, exchange2, false, null, null, callback, code);
    }

    protected void ifNotException(Throwable ex, Exchange exchange2, boolean handleCompletion, CamelSagaCoordinator coordinator, CamelSagaCoordinator previousCoordinator, AsyncCallback callback, Runnable code) {
        if (ex != null) {
            exchange2.setException(ex);
            if (handleCompletion) {
                this.handleSagaCompletion(exchange2, coordinator, previousCoordinator, callback);
            } else {
                callback.done(false);
            }
        } else {
            code.run();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.sagaService);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.sagaService);
    }
}

