/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.component.RawParameterHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComponent.class);
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW[({].*&&.*[)}]");
    private volatile PropertyConfigurer componentPropertyConfigurer;
    private volatile PropertyConfigurer endpointPropertyConfigurer;
    private volatile String defaultName;
    private final List<Supplier<ComponentExtension>> extensions = new ArrayList<Supplier<ComponentExtension>>();
    private CamelContext camelContext;
    @Metadata(label="advanced", defaultValue="true", description="Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.")
    private boolean autowiredEnabled = true;
    @Metadata(label="consumer", description="Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions (if possible) occurred while the Camel consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. Important: This is only possible if the 3rd party component allows Camel to be alerted if an exception was thrown. Some components handle this internally only, and therefore bridgeErrorHandler is not possible. In other situations we may improve the Camel component to hook into the 3rd party component and make this possible for future releases. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private boolean bridgeErrorHandler;
    @Metadata(label="producer", description="Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.")
    private boolean lazyStartProducer;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Override
    public Endpoint createEndpoint(String uri, Map<String, Object> properties) throws Exception {
        Endpoint endpoint;
        Map<String, Object> parameters;
        String encodedUri = UnsafeUriCharactersEncoder.encode(uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath(u, this.useRawUri()) : null;
        if (this.useRawUri()) {
            String query = StringHelper.after(uri, "?");
            if (query == null) {
                query = u.getRawQuery();
            }
            parameters = URISupport.parseQuery(query, true);
        } else {
            parameters = URISupport.parseParameters(u);
        }
        if (properties != null) {
            parameters.putAll(properties);
        }
        parameters.remove("hash");
        if (this.resolveRawParameterValues()) {
            RawParameterHelper.resolveRawParameterValues(this.camelContext, parameters);
        }
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri(uri), URISupport.sanitizePath(path), parameters});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri(uri), (Object)URISupport.sanitizePath(path));
        }
        boolean bridge = this.bridgeErrorHandler || this.getCamelContext().getGlobalEndpointConfiguration().isBridgeErrorHandler();
        Boolean bool = this.getAndRemoveParameter(parameters, "bridgeErrorHandler", Boolean.class);
        if (bool != null) {
            bridge = bool;
        }
        boolean lazy = this.lazyStartProducer || this.getCamelContext().getGlobalEndpointConfiguration().isLazyStartProducer();
        bool = this.getAndRemoveParameter(parameters, "lazyStartProducer", Boolean.class);
        if (bool != null) {
            lazy = bool;
        }
        boolean autowire = this.camelContext.isAutowiredEnabled() != false && (this.autowiredEnabled || this.getCamelContext().getGlobalEndpointConfiguration().isAutowiredEnabled());
        bool = this.getAndRemoveParameter(parameters, "autowiredEnabled", Boolean.class);
        if (bool != null) {
            autowire = bool;
        }
        if ((endpoint = this.createEndpoint(uri, path, parameters)) == null) {
            return null;
        }
        endpoint.setCamelContext(this.getCamelContext());
        if (endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            de.setBridgeErrorHandler(bridge);
            de.setLazyStartProducer(lazy);
            de.setAutowiredEnabled(autowire);
        }
        this.setProperties(endpoint, parameters);
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        if (endpoint instanceof AfterPropertiesConfigured) {
            AfterPropertiesConfigured afterPropertiesConfigured = (AfterPropertiesConfigured)((Object)endpoint);
            afterPropertiesConfigured.afterPropertiesConfigured(this.getCamelContext());
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    @Override
    public Endpoint createEndpoint(String uri) throws Exception {
        return this.createEndpoint(uri, null);
    }

    @Override
    public boolean useRawUri() {
        return false;
    }

    public boolean isLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    @Override
    public boolean isAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map<String, Object> param = parameters;
        if (optionPrefix != null) {
            param = PropertiesHelper.extractProperties(parameters, optionPrefix);
        }
        if (!param.isEmpty()) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + String.valueOf(param) + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Matcher m;
        if (uri.contains("&&") && !(m = RAW_PATTERN.matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    protected boolean resolveRawParameterValues() {
        return true;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    protected void doBuild() throws Exception {
        org.apache.camel.spi.annotations.Component ann;
        if (this.defaultName == null && (ann = ObjectHelper.getAnnotation(this, org.apache.camel.spi.annotations.Component.class)) != null) {
            String name = ann.value();
            if (name.contains(",")) {
                name = StringHelper.before(name, ",");
            }
            this.defaultName = name;
        }
        if (this.defaultName != null) {
            if (this.componentPropertyConfigurer == null) {
                this.componentPropertyConfigurer = PluginHelper.getConfigurerResolver(this.getCamelContext()).resolvePropertyConfigurer(this.defaultName + "-component-configurer", this.getCamelContext());
            }
            if (this.endpointPropertyConfigurer == null) {
                this.endpointPropertyConfigurer = PluginHelper.getConfigurerResolver(this.getCamelContext()).resolvePropertyConfigurer(this.defaultName + "-endpoint-configurer", this.getCamelContext());
            }
        }
    }

    @Override
    protected void doInit() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        endpoint.configureProperties(parameters);
    }

    protected void setProperties(Object bean2, Map<String, Object> parameters) throws Exception {
        this.setProperties(this.getCamelContext(), bean2, parameters);
    }

    protected void setProperties(CamelContext camelContext, Object bean2, Map<String, Object> parameters) throws Exception {
        PropertyConfigurer configurer;
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        if (bean2 instanceof Component) {
            configurer = this.getComponentPropertyConfigurer();
        } else if (bean2 instanceof Endpoint) {
            configurer = this.getEndpointPropertyConfigurer();
        } else if (bean2 instanceof PropertyConfigurerAware) {
            PropertyConfigurerAware propertyConfigurerAware = (PropertyConfigurerAware)bean2;
            configurer = propertyConfigurerAware.getPropertyConfigurer(bean2);
        } else {
            configurer = null;
        }
        PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).bind(camelContext, bean2, parameters);
    }

    @Override
    public PropertyConfigurer getComponentPropertyConfigurer() {
        return this.componentPropertyConfigurer;
    }

    @Override
    public PropertyConfigurer getEndpointPropertyConfigurer() {
        return this.endpointPropertyConfigurer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value != null) {
            return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
        }
        value = defaultValue;
        if (value == null) {
            return null;
        }
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String str;
        Object value = parameters.remove(key);
        if (value instanceof String && EndpointHelper.isReferenceParameter(str = (String)value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        if (type.isInstance(value)) {
            if (String.class == type && EndpointHelper.isReferenceParameter(str = value.toString())) {
                value = EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
            }
            return type.cast(value);
        }
        if (value == null) {
            return defaultValue;
        }
        str = this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        if (EndpointHelper.isReferenceParameter(str)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        return this.getCamelContext().getTypeConverter().convertTo(type, value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String str;
        Object value = parameters.remove(key);
        if (value instanceof String && EndpointHelper.isReferenceParameter(str = (String)value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
        }
        if (type.isInstance(value)) {
            if (String.class == type && EndpointHelper.isReferenceParameter(str = value.toString())) {
                value = EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
            }
            return type.cast(value);
        }
        if (value == null) {
            return defaultValue;
        }
        str = this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), str, type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        Object value = this.getAndRemoveParameter(parameters, key, Object.class);
        if (value instanceof List) {
            return (List)value;
        }
        if (value == null) {
            return defaultValue;
        }
        String str = this.getCamelContext().getTypeConverter().tryConvertTo(String.class, value);
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), str, elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && !(remainder = text.substring(prefix.length())).isEmpty()) {
            return remainder;
        }
        return null;
    }

    protected void registerExtension(ComponentExtension extension) {
        this.extensions.add(() -> extension);
    }

    protected void registerExtension(Supplier<ComponentExtension> supplier) {
        this.extensions.add(Suppliers.memorize(supplier));
    }

    @Override
    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        return this.extensions.stream().map(Supplier::get).map((Function<ComponentExtension, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/apache/camel/component/extension/ComponentExtension;)Ljava/lang/Class;)()).collect(Collectors.toList());
    }

    @Override
    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        return this.extensions.stream().map(Supplier::get).filter(extensionType::isInstance).findFirst().map(extensionType::cast).map(e -> Component.trySetComponent(e, this)).map(e -> CamelContextAware.trySetCamelContext(e, this.getCamelContext()));
    }
}

