/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class DeferProducer
extends ServiceSupport
implements Producer,
AsyncProcessor {
    private Producer delegate;
    private final Endpoint endpoint;

    public DeferProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange2) throws Exception {
        if (this.delegate == null) {
            throw new IllegalStateException("Not started");
        }
        this.delegate.process(exchange2);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (this.delegate == null) {
            exchange2.setException(new IllegalStateException("Not started"));
            callback.done(true);
            return true;
        }
        Producer producer = this.delegate;
        if (producer instanceof AsyncProcessor) {
            AsyncProcessor asyncProcessor = (AsyncProcessor)((Object)producer);
            return asyncProcessor.process(exchange2, callback);
        }
        try {
            this.process(exchange2);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange2) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange2);
        this.process(exchange2, callback);
        return callback.getFuture();
    }

    @Override
    protected void doStart() throws Exception {
        Endpoint lookup = this.endpoint.getCamelContext().getEndpoint(this.endpoint.getEndpointUri());
        this.delegate = lookup.createProducer();
        ServiceHelper.startService(this.delegate);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.delegate);
    }

    @Override
    public boolean isSingleton() {
        if (this.delegate != null) {
            return this.delegate.isSingleton();
        }
        return true;
    }

    @Override
    public Endpoint getEndpoint() {
        if (this.delegate != null) {
            return this.delegate.getEndpoint();
        }
        return this.endpoint;
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        return "DelegateProducer[" + String.valueOf(this.endpoint) + "]";
    }
}

