/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public final class GZIPHelper {
    private GZIPHelper() {
    }

    public static InputStream uncompressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, InputStream in) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(os);
            try {
                IOHelper.copy(in, gzip);
                gzip.finish();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                IOHelper.close((Closeable)gzip, "gzip");
                IOHelper.close((Closeable)os, "byte array output stream");
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream compressGzip(String contentEncoding, byte[] data) throws IOException {
        if (GZIPHelper.isGzip(contentEncoding)) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream os = null;
            GZIPOutputStream gzip = null;
            try {
                os = new ByteArrayOutputStream();
                gzip = new GZIPOutputStream(os);
                gzip.write(data);
                gzip.finish();
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            }
            catch (Throwable throwable) {
                IOHelper.close(gzip, "gzip");
                IOHelper.close((Closeable)os, "byte array output stream");
                throw throwable;
            }
            IOHelper.close((Closeable)gzip, "gzip");
            IOHelper.close((Closeable)os, "byte array output stream");
            return byteArrayInputStream;
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressGZIP(byte[] data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        try {
            gzip.write(data);
            gzip.finish();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)gzip, "gzip");
            IOHelper.close((Closeable)os, "byte array output stream");
        }
    }

    public static boolean isGzip(Message message) {
        return GZIPHelper.isGzip(message.getHeader("Content-Encoding", String.class), message.getExchange());
    }

    public static boolean isGzip(String header, Exchange exchange2) {
        if (exchange2 == null || !exchange2.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class).booleanValue()) {
            return GZIPHelper.isGzip(header);
        }
        return false;
    }

    public static boolean isGzip(String header) {
        return StringHelper.containsIgnoreCase(header, "gzip");
    }
}

