/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

public final class PredicateAssertHelper {
    private PredicateAssertHelper() {
    }

    public static void assertMatches(Predicate predicate, String text, Exchange exchange2) {
        ObjectHelper.notNull(predicate, "predicate");
        ObjectHelper.notNull(exchange2, "exchange");
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate eval = (BinaryPredicate)predicate;
            String evalText = eval.matchesReturningFailureMessage(exchange2);
            if (evalText != null) {
                throw new AssertionError((Object)(text + String.valueOf(predicate) + " evaluated as: " + evalText + " on " + String.valueOf(exchange2)));
            }
        } else {
            PredicateAssertHelper.doAssertMatches(predicate, text, exchange2);
        }
    }

    private static void doAssertMatches(Predicate predicate, String text, Exchange exchange2) {
        if (!predicate.matches(exchange2)) {
            if (text == null) {
                throw new AssertionError((Object)(String.valueOf(predicate) + " on " + String.valueOf(exchange2)));
            }
            throw new AssertionError((Object)(text + String.valueOf(predicate) + " on " + String.valueOf(exchange2)));
        }
    }
}

