/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.util.ObjectHelper;

public abstract class BinaryPredicateSupport
implements BinaryPredicate {
    private final Expression left;
    private final Expression right;

    protected BinaryPredicateSupport(Expression left, Expression right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        this.left = left;
        this.right = right;
    }

    @Override
    public void init(CamelContext context) {
        this.left.init(context);
        this.right.init(context);
    }

    public String toString() {
        return String.valueOf(this.left) + " " + this.getOperationText() + " " + String.valueOf(this.right);
    }

    @Override
    public boolean matches(Exchange exchange2) {
        return this.matchesReturningFailureMessage(exchange2) == null;
    }

    @Override
    public String matchesReturningFailureMessage(Exchange exchange2) {
        Object rightValue;
        String answer = null;
        Object leftValue = this.left.evaluate(exchange2, Object.class);
        if (!this.matches(exchange2, leftValue, rightValue = this.right.evaluate(exchange2, Object.class))) {
            answer = String.valueOf(leftValue) + " " + this.getOperator() + " " + String.valueOf(rightValue);
        }
        return answer;
    }

    protected abstract boolean matches(Exchange var1, Object var2, Object var3);

    protected abstract String getOperationText();

    @Override
    public Expression getLeft() {
        return this.left;
    }

    @Override
    public Expression getRight() {
        return this.right;
    }

    @Override
    public String getOperator() {
        return this.getOperationText();
    }
}

