/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.service.ServiceHelper;

public class EmptyProducerCache
extends DefaultProducerCache {
    private final Object source;
    private final CamelContext ecc;

    public EmptyProducerCache(Object source, CamelContext camelContext) {
        super(source, camelContext, -1);
        this.source = source;
        this.ecc = camelContext;
        this.setExtendedStatistics(false);
    }

    @Override
    public AsyncProducer acquireProducer(Endpoint endpoint) {
        AsyncProducer answer;
        try {
            boolean startingRoutes;
            answer = endpoint.createAsyncProducer();
            boolean bl = startingRoutes = this.ecc.getCamelContextExtension().isSetupRoutes() || this.ecc.getRouteController().isStartingRoutes();
            if (startingRoutes && answer.isSingleton()) {
                this.getCamelContext().addService(answer);
            } else {
                ServiceHelper.startService(answer);
            }
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(endpoint, (Throwable)e);
        }
        return answer;
    }

    @Override
    public void releaseProducer(Endpoint endpoint, AsyncProducer producer) {
        ServiceHelper.stopAndShutdownService(producer);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public String toString() {
        return "EmptyProducerCache for source: " + String.valueOf(this.source);
    }
}

