/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class MarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;
    private String variableSend;
    private String variableReceive;

    public MarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        Object originalBody;
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange2);
        Message in = exchange2.getIn();
        Object body2 = originalBody = in.getBody();
        if (this.variableSend != null) {
            body2 = ExchangeHelper.getVariable(exchange2, this.variableSend);
        }
        Message out = exchange2.getOut();
        out.copyFrom(in);
        try {
            this.dataFormat.marshal(exchange2, body2, osb);
            Object result = osb.build();
            if (this.variableReceive != null) {
                ExchangeHelper.setVariable(exchange2, this.variableReceive, result);
            } else {
                out.setBody(result);
            }
        }
        catch (Exception e) {
            exchange2.setOut(null);
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Marshal[" + String.valueOf(this.dataFormat) + "]";
    }

    @Override
    public String getTraceLabel() {
        return "marshal[" + String.valueOf(this.dataFormat) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    @Override
    protected void doStart() throws Exception {
        CamelContextAware.trySetCamelContext(this.dataFormat, this.camelContext);
        this.getCamelContext().addService(this.dataFormat, false, true);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
        this.getCamelContext().removeService(this.dataFormat);
    }
}

