/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class UnmarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;
    private final boolean allowNullBody;
    private String variableSend;
    private String variableReceive;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this(dataFormat, false);
    }

    public UnmarshalProcessor(DataFormat dataFormat, boolean allowNullBody) {
        this.dataFormat = dataFormat;
        this.allowNullBody = allowNullBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        block21: {
            ObjectHelper.notNull(this.dataFormat, "dataFormat");
            InputStream stream = null;
            Object result = null;
            try {
                Message out;
                Object originalBody;
                Message in = exchange2.getIn();
                Object body2 = originalBody = in.getBody();
                if (this.variableSend != null) {
                    body2 = ExchangeHelper.getVariable(exchange2, this.variableSend);
                }
                if (this.allowNullBody && body2 == null) {
                    out = exchange2.getOut();
                } else {
                    out = exchange2.getOut();
                    out.copyFrom(in);
                    if (body2 instanceof InputStream) {
                        InputStream is;
                        stream = is = (InputStream)body2;
                        result = this.dataFormat.unmarshal(exchange2, stream);
                    } else {
                        result = this.dataFormat.unmarshal(exchange2, body2);
                    }
                }
                if (result instanceof Exchange) {
                    if (result != exchange2) {
                        throw new RuntimeCamelException("The returned exchange " + String.valueOf(result) + " is not the same as " + String.valueOf(exchange2) + " provided to the DataFormat");
                    }
                } else if (result instanceof Message) {
                    Message msg = (Message)result;
                    if (this.variableReceive != null) {
                        Object value = msg.getBody();
                        ExchangeHelper.setVariable(exchange2, this.variableReceive, value);
                    } else {
                        exchange2.setOut(msg);
                    }
                } else if (this.variableReceive != null) {
                    ExchangeHelper.setVariable(exchange2, this.variableReceive, result);
                } else {
                    out.setBody(result);
                }
                if (result instanceof Iterator) break block21;
            }
            catch (Exception e) {
                exchange2.setOut(null);
                exchange2.setException(e);
                break block21;
            }
            IOHelper.close((Closeable)stream, "input stream");
            break block21;
            finally {
                if (!(result instanceof Iterator)) {
                    IOHelper.close(stream, "input stream");
                }
            }
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Unmarshal[" + String.valueOf(this.dataFormat) + "]";
    }

    @Override
    public String getTraceLabel() {
        return "unmarshal[" + String.valueOf(this.dataFormat) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    @Override
    protected void doStart() throws Exception {
        CamelContextAware.trySetCamelContext(this.dataFormat, this.camelContext);
        this.getCamelContext().addService(this.dataFormat, false, true);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
        this.getCamelContext().removeService(this.dataFormat);
    }
}

