/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.service.RSocketExchange;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class RSocketExchangeBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    RSocketExchangeBeanRegistrationAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        HashSet exchangeInterfaces = new HashSet();
        MergedAnnotations.Search search = MergedAnnotations.search(MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        for (Class<?> interfaceClass : ClassUtils.getAllInterfacesForClass(beanClass)) {
            ReflectionUtils.doWithMethods(interfaceClass, method -> {
                if (!exchangeInterfaces.contains(interfaceClass) && search.from(method).isPresent(RSocketExchange.class)) {
                    exchangeInterfaces.add(interfaceClass);
                }
            });
        }
        if (!exchangeInterfaces.isEmpty()) {
            return new RSocketExchangeBeanRegistrationContribution(exchangeInterfaces);
        }
        return null;
    }

    private static class RSocketExchangeBeanRegistrationContribution
    implements BeanRegistrationAotContribution {
        private final Set<Class<?>> rSocketExchangeInterfaces;

        public RSocketExchangeBeanRegistrationContribution(Set<Class<?>> rSocketExchangeInterfaces) {
            this.rSocketExchangeInterfaces = rSocketExchangeInterfaces;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            for (Class<?> rSocketExchangeInterface : this.rSocketExchangeInterfaces) {
                proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces(rSocketExchangeInterface));
            }
        }
    }
}

