/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.NoEndpointFoundException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointAdapter;
import org.springframework.ws.server.EndpointExceptionResolver;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.EndpointMapping;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public class MessageDispatcher
implements WebServiceMessageReceiver,
BeanNameAware,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String ENDPOINT_NOT_FOUND_LOG_CATEGORY = "org.springframework.ws.server.EndpointNotFound";
    protected static final Log endpointNotFoundLogger = LogFactory.getLog("org.springframework.ws.server.EndpointNotFound");
    public static final String MESSAGE_TRACING_LOG_CATEGORY = "org.springframework.ws.server.MessageTracing";
    protected static final Log sentMessageTracingLogger = LogFactory.getLog("org.springframework.ws.server.MessageTracing.sent");
    protected static final Log receivedMessageTracingLogger = LogFactory.getLog("org.springframework.ws.server.MessageTracing.received");
    private final DefaultStrategiesHelper defaultStrategiesHelper = new DefaultStrategiesHelper(this.getClass());
    private String beanName;
    private List<EndpointAdapter> endpointAdapters;
    private List<EndpointExceptionResolver> endpointExceptionResolvers;
    private List<EndpointMapping> endpointMappings;

    public List<EndpointAdapter> getEndpointAdapters() {
        return this.endpointAdapters;
    }

    public void setEndpointAdapters(List<EndpointAdapter> endpointAdapters) {
        this.endpointAdapters = endpointAdapters;
    }

    public List<EndpointExceptionResolver> getEndpointExceptionResolvers() {
        return this.endpointExceptionResolvers;
    }

    public void setEndpointExceptionResolvers(List<EndpointExceptionResolver> endpointExceptionResolvers) {
        this.endpointExceptionResolvers = endpointExceptionResolvers;
    }

    public List<EndpointMapping> getEndpointMappings() {
        return this.endpointMappings;
    }

    public void setEndpointMappings(List<EndpointMapping> endpointMappings) {
        this.endpointMappings = endpointMappings;
    }

    @Override
    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.initEndpointAdapters(applicationContext);
        this.initEndpointExceptionResolvers(applicationContext);
        this.initEndpointMappings(applicationContext);
    }

    @Override
    public void receive(MessageContext messageContext) throws Exception {
        String requestContent = "";
        if (receivedMessageTracingLogger.isTraceEnabled() || sentMessageTracingLogger.isTraceEnabled()) {
            requestContent = this.getMessageContent(messageContext.getRequest());
        }
        if (receivedMessageTracingLogger.isTraceEnabled()) {
            receivedMessageTracingLogger.trace("Received request [" + requestContent + "]");
        } else if (receivedMessageTracingLogger.isDebugEnabled()) {
            receivedMessageTracingLogger.debug("Received request [" + messageContext.getRequest() + "]");
        }
        this.dispatch(messageContext);
        if (messageContext.hasResponse()) {
            WebServiceMessage response = messageContext.getResponse();
            if (sentMessageTracingLogger.isTraceEnabled()) {
                String responseContent = this.getMessageContent(response);
                sentMessageTracingLogger.trace("Sent response [" + responseContent + "] for request [" + requestContent + "]");
            } else if (sentMessageTracingLogger.isDebugEnabled()) {
                sentMessageTracingLogger.debug("Sent response [" + response + "] for request [" + messageContext.getRequest() + "]");
            }
        } else if (sentMessageTracingLogger.isDebugEnabled()) {
            sentMessageTracingLogger.debug("MessageDispatcher with name '" + this.beanName + "' sends no response for request [" + messageContext.getRequest() + "]");
        }
    }

    private String getMessageContent(WebServiceMessage message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        message.writeTo(bos);
        return bos.toString(StandardCharsets.UTF_8);
    }

    protected final void dispatch(MessageContext messageContext) throws Exception {
        EndpointInvocationChain mappedEndpoint = null;
        int interceptorIndex = -1;
        try {
            try {
                mappedEndpoint = this.getEndpoint(messageContext);
                if (mappedEndpoint == null || mappedEndpoint.getEndpoint() == null) {
                    throw new NoEndpointFoundException(messageContext.getRequest());
                }
                if (!this.handleRequest(mappedEndpoint, messageContext)) {
                    return;
                }
                if (mappedEndpoint.getInterceptors() != null) {
                    int i2 = 0;
                    while (i2 < mappedEndpoint.getInterceptors().length) {
                        EndpointInterceptor interceptor = mappedEndpoint.getInterceptors()[i2];
                        interceptorIndex = i2++;
                        if (interceptor.handleRequest(messageContext, mappedEndpoint.getEndpoint())) continue;
                        this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
                        this.triggerAfterCompletion(mappedEndpoint, interceptorIndex, messageContext, null);
                        return;
                    }
                }
                EndpointAdapter endpointAdapter = this.getEndpointAdapter(mappedEndpoint.getEndpoint());
                endpointAdapter.invoke(messageContext, mappedEndpoint.getEndpoint());
                this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
            }
            catch (NoEndpointFoundException ex) {
                if (endpointNotFoundLogger.isWarnEnabled()) {
                    endpointNotFoundLogger.warn("No endpoint mapping found for [" + messageContext.getRequest() + "]");
                }
                throw ex;
            }
            catch (Exception ex) {
                Object endpoint = mappedEndpoint != null ? mappedEndpoint.getEndpoint() : null;
                this.processEndpointException(messageContext, endpoint, ex);
                this.triggerHandleResponse(mappedEndpoint, interceptorIndex, messageContext);
            }
            this.triggerAfterCompletion(mappedEndpoint, interceptorIndex, messageContext, null);
        }
        catch (NoEndpointFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.triggerAfterCompletion(mappedEndpoint, interceptorIndex, messageContext, ex);
            throw ex;
        }
    }

    protected EndpointInvocationChain getEndpoint(MessageContext messageContext) throws Exception {
        for (EndpointMapping endpointMapping : this.getEndpointMappings()) {
            EndpointInvocationChain endpoint = endpointMapping.getEndpoint(messageContext);
            if (endpoint != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Endpoint mapping [" + endpointMapping + "] maps request to endpoint [" + endpoint.getEndpoint() + "]");
                }
                return endpoint;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Endpoint mapping [" + endpointMapping + "] has no mapping for request");
        }
        return null;
    }

    protected EndpointAdapter getEndpointAdapter(Object endpoint) {
        for (EndpointAdapter endpointAdapter : this.getEndpointAdapters()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Testing endpoint adapter [" + endpointAdapter + "]");
            }
            if (!endpointAdapter.supports(endpoint)) continue;
            return endpointAdapter;
        }
        throw new IllegalStateException("No adapter for endpoint [" + endpoint + "]: Is your endpoint annotated with @Endpoint, or does it implement a supported interface like MessageHandler or PayloadEndpoint?");
    }

    protected boolean handleRequest(EndpointInvocationChain mappedEndpoint, MessageContext messageContext) {
        return true;
    }

    protected void processEndpointException(MessageContext messageContext, Object endpoint, Exception ex) throws Exception {
        if (!CollectionUtils.isEmpty(this.getEndpointExceptionResolvers())) {
            for (EndpointExceptionResolver resolver : this.getEndpointExceptionResolvers()) {
                if (!resolver.resolveException(messageContext, endpoint, ex)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Endpoint invocation resulted in exception - responding with Fault", ex);
                }
                return;
            }
        }
        throw ex;
    }

    private void triggerHandleResponse(EndpointInvocationChain mappedEndpoint, int interceptorIndex, MessageContext messageContext) throws Exception {
        if (mappedEndpoint != null && messageContext.hasResponse() && !ObjectUtils.isEmpty(mappedEndpoint.getInterceptors())) {
            boolean hasFault = false;
            WebServiceMessage response = messageContext.getResponse();
            if (response instanceof FaultAwareWebServiceMessage) {
                hasFault = ((FaultAwareWebServiceMessage)response).hasFault();
            }
            boolean resume = true;
            for (int i2 = interceptorIndex; resume && i2 >= 0; --i2) {
                EndpointInterceptor interceptor = mappedEndpoint.getInterceptors()[i2];
                resume = !hasFault ? interceptor.handleResponse(messageContext, mappedEndpoint.getEndpoint()) : interceptor.handleFault(messageContext, mappedEndpoint.getEndpoint());
            }
        }
    }

    private void triggerAfterCompletion(EndpointInvocationChain mappedEndpoint, int interceptorIndex, MessageContext messageContext, Exception ex) throws Exception {
        EndpointInterceptor[] interceptors;
        if (mappedEndpoint != null && (interceptors = mappedEndpoint.getInterceptors()) != null) {
            for (int i2 = interceptorIndex; i2 >= 0; --i2) {
                EndpointInterceptor interceptor = interceptors[i2];
                try {
                    interceptor.afterCompletion(messageContext, mappedEndpoint.getEndpoint(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error("EndpointInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    private void initEndpointAdapters(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointAdapters == null) {
            Map<String, EndpointAdapter> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, EndpointAdapter.class, true, false);
            if (!matchingBeans.isEmpty()) {
                this.endpointAdapters = new ArrayList<EndpointAdapter>(matchingBeans.values());
                this.endpointAdapters.sort(new OrderComparator());
            } else {
                this.endpointAdapters = this.defaultStrategiesHelper.getDefaultStrategies(EndpointAdapter.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No EndpointAdapters found, using defaults");
                }
            }
        }
    }

    private void initEndpointExceptionResolvers(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointExceptionResolvers == null) {
            Map<String, EndpointExceptionResolver> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, EndpointExceptionResolver.class, true, false);
            if (!matchingBeans.isEmpty()) {
                this.endpointExceptionResolvers = new ArrayList<EndpointExceptionResolver>(matchingBeans.values());
                this.endpointExceptionResolvers.sort(new OrderComparator());
            } else {
                this.endpointExceptionResolvers = this.defaultStrategiesHelper.getDefaultStrategies(EndpointExceptionResolver.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No EndpointExceptionResolvers found, using defaults");
                }
            }
        }
    }

    private void initEndpointMappings(ApplicationContext applicationContext) throws BeansException {
        if (this.endpointMappings == null) {
            Map<String, EndpointMapping> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, EndpointMapping.class, true, false);
            if (!matchingBeans.isEmpty()) {
                this.endpointMappings = new ArrayList<EndpointMapping>(matchingBeans.values());
                this.endpointMappings.sort(new OrderComparator());
            } else {
                this.endpointMappings = this.defaultStrategiesHelper.getDefaultStrategies(EndpointMapping.class, applicationContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No EndpointMappings found, using defaults");
                }
            }
        }
    }
}

