/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.springframework.ws.server.endpoint.support.NamespaceUtils;
import org.springframework.xml.transform.TransformerHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathParamMethodArgumentResolver
implements MethodArgumentResolver {
    private final XPathFactory xpathFactory = this.createXPathFactory();
    private TransformerHelper transformerHelper = new TransformerHelper();
    private ConversionService conversionService = new DefaultConversionService();

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setTransformerHelper(TransformerHelper transformerHelper) {
        this.transformerHelper = transformerHelper;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.getParameterAnnotation(XPathParam.class) == null) {
            return false;
        }
        Class<?> parameterType = parameter.getParameterType();
        if (Boolean.class.equals(parameterType) || Boolean.TYPE.equals(parameterType) || Double.class.equals(parameterType) || Double.TYPE.equals(parameterType) || Node.class.isAssignableFrom(parameterType) || NodeList.class.isAssignableFrom(parameterType) || String.class.isAssignableFrom(parameterType)) {
            return true;
        }
        return this.conversionService.canConvert(String.class, parameterType);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws TransformerException, XPathExpressionException {
        Class<?> parameterType = parameter.getParameterType();
        QName evaluationReturnType = this.getReturnType(parameterType);
        boolean useConversionService = false;
        if (evaluationReturnType == null) {
            evaluationReturnType = XPathConstants.STRING;
            useConversionService = true;
        }
        XPath xpath = this.createXPath();
        xpath.setNamespaceContext(NamespaceUtils.getNamespaceContext(parameter.getMethod()));
        Element rootElement = this.getRootElement(messageContext.getRequest().getPayloadSource());
        String expression = parameter.getParameterAnnotation(XPathParam.class).value();
        Object result = xpath.evaluate(expression, rootElement, evaluationReturnType);
        return useConversionService ? this.conversionService.convert(result, parameterType) : result;
    }

    private QName getReturnType(Class<?> parameterType) {
        if (Boolean.class.equals(parameterType) || Boolean.TYPE.equals(parameterType)) {
            return XPathConstants.BOOLEAN;
        }
        if (Double.class.equals(parameterType) || Double.TYPE.equals(parameterType)) {
            return XPathConstants.NUMBER;
        }
        if (Node.class.equals(parameterType)) {
            return XPathConstants.NODE;
        }
        if (NodeList.class.equals(parameterType)) {
            return XPathConstants.NODESET;
        }
        if (String.class.equals(parameterType)) {
            return XPathConstants.STRING;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPath createXPath() {
        XPathFactory xPathFactory = this.xpathFactory;
        synchronized (xPathFactory) {
            return this.xpathFactory.newXPath();
        }
    }

    private Element getRootElement(Source source) throws TransformerException {
        DOMResult domResult = new DOMResult();
        this.transformerHelper.transform(source, domResult);
        Document document = (Document)domResult.getNode();
        return document.getDocumentElement();
    }

    protected XPathFactory createXPathFactory() {
        return XPathFactory.newInstance();
    }
}

