/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.dom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;

public class Dom4jPayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected Element resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws TransformerException {
        org.w3c.dom.Node node;
        if (requestPayload instanceof DOMSource && (node = ((DOMSource)requestPayload).getNode()).getNodeType() == 9) {
            DOMReader domReader = new DOMReader();
            Document document = domReader.read((org.w3c.dom.Document)node);
            return document.getRootElement();
        }
        DocumentResult dom4jResult = new DocumentResult();
        this.transform(requestPayload, (Result)dom4jResult);
        return dom4jResult.getDocument().getRootElement();
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    @Override
    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) {
        Element returnedElement = (Element)returnValue;
        return new DocumentSource((Node)returnedElement);
    }

    private boolean supports(MethodParameter parameter) {
        return Element.class.equals(parameter.getParameterType());
    }
}

