/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.dom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDomPayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected org.jdom2.Element resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws Exception {
        if (requestPayload instanceof DOMSource) {
            Node node = ((DOMSource)requestPayload).getNode();
            DOMBuilder domBuilder = new DOMBuilder();
            if (node.getNodeType() == 1) {
                return domBuilder.build((Element)node);
            }
            if (node.getNodeType() == 9) {
                Document document = domBuilder.build((org.w3c.dom.Document)node);
                return document.getRootElement();
            }
        }
        JDOMResult jdomResult = new JDOMResult();
        this.transform(requestPayload, (Result)jdomResult);
        return jdomResult.getDocument().getRootElement();
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    @Override
    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) {
        org.jdom2.Element returnedElement = (org.jdom2.Element)returnValue;
        return new JDOMSource(returnedElement);
    }

    private boolean supports(MethodParameter parameter) {
        return org.jdom2.Element.class.equals(parameter.getParameterType());
    }
}

