/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.soap.addressing.server.AbstractActionEndpointMapping;

public abstract class AbstractActionMethodEndpointMapping
extends AbstractActionEndpointMapping {
    protected void registerMethods(Object endpoint) {
        Method[] methods;
        Assert.notNull(endpoint, "'endpoint' must not be null");
        for (Method method : methods = AopUtils.getTargetClass(endpoint).getMethods()) {
            URI action;
            if (method.isSynthetic() || method.getDeclaringClass().equals(Object.class) || (action = this.getActionForMethod(method)) == null) continue;
            this.registerEndpoint(action, new MethodEndpoint(endpoint, method));
        }
    }

    protected abstract URI getActionForMethod(Method var1);

    protected Class<?> getEndpointClass(Object endpoint) {
        return AopUtils.getTargetClass(endpoint);
    }
}

