/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.adapter.method;

import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;

public class SoapMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class<?> parameterType = parameter.getParameterType();
        return SoapMessage.class.equals(parameterType) || SoapBody.class.equals(parameterType) || SoapEnvelope.class.equals(parameterType) || SoapHeader.class.equals(parameterType);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) {
        Assert.isInstanceOf(SoapMessage.class, messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        Class<?> parameterType = parameter.getParameterType();
        if (SoapMessage.class.equals(parameterType)) {
            return request;
        }
        if (SoapBody.class.equals(parameterType)) {
            return request.getSoapBody();
        }
        if (SoapEnvelope.class.equals(parameterType)) {
            return request.getEnvelope();
        }
        if (SoapHeader.class.equals(parameterType)) {
            return request.getSoapHeader();
        }
        throw new UnsupportedOperationException();
    }
}

