/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import jakarta.jms.JMSException;
import jakarta.jms.TextMessage;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.ws.transport.jms.JmsTransportException;

class TextMessageOutputStream
extends FilterOutputStream {
    private final TextMessage message;
    private final String encoding;

    TextMessageOutputStream(TextMessage message, String encoding) {
        super(new ByteArrayOutputStream());
        Assert.notNull((Object)message, "'message' must not be null");
        Assert.notNull((Object)encoding, "'encoding' must not be null");
        this.message = message;
        this.encoding = encoding;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            String text = baos.toString(this.encoding);
            this.message.setText(text);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }
}

