/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.support;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.ClassUtils;
import org.springframework.ws.transport.support.AbstractStandaloneMessageReceiver;

public abstract class AbstractAsyncStandaloneMessageReceiver
extends AbstractStandaloneMessageReceiver
implements BeanNameAware {
    public final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(this.getClass()) + "-";
    private TaskExecutor taskExecutor;
    private String beanName;

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.taskExecutor == null) {
            this.taskExecutor = this.createDefaultTaskExecutor();
        }
        super.afterPropertiesSet();
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        Object threadNamePrefix = this.beanName != null ? this.beanName + "-" : this.DEFAULT_THREAD_NAME_PREFIX;
        return new SimpleAsyncTaskExecutor((String)threadNamePrefix);
    }

    protected void execute(Runnable runnable) {
        this.taskExecutor.execute(runnable);
    }
}

