/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.zeno;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.ma.zeno.ZenoChainIterator;

public class ZenoChain<T>
implements Iterable<T> {
    private final ArrayList<ArrayList<T>> masterList;

    public ZenoChain() {
        this.masterList = new ArrayList(8);
    }

    private ZenoChain(ArrayList<ArrayList<T>> masterList) {
        this.masterList = masterList;
    }

    public ZenoChain<T> add(T item) {
        ArrayList<ArrayList<T>> masterList2 = new ArrayList<ArrayList<T>>(this.masterList);
        if (masterList2.isEmpty()) {
            ArrayList<T> newSegment = new ArrayList<T>(32);
            newSegment.add(item);
            masterList2.add(newSegment);
            return new ZenoChain<T>(masterList2);
        }
        int threshold = 32;
        int index = masterList2.size() - 1;
        ArrayList<T> segment = masterList2.get(index);
        if (segment.size() < threshold) {
            ArrayList<T> segment2 = new ArrayList<T>(32);
            segment2.addAll(segment);
            segment2.add(item);
            masterList2.set(index, segment2);
            return new ZenoChain<T>(masterList2);
        }
        while (true) {
            threshold *= 2;
            if (--index < 0) {
                ArrayList<T> newFinalSegment = new ArrayList<T>();
                newFinalSegment.add(item);
                masterList2.add(newFinalSegment);
                return new ZenoChain<T>(masterList2);
            }
            ArrayList<T> priorSegment = masterList2.get(index);
            if (priorSegment.size() + segment.size() <= threshold) {
                ArrayList<T> combinedSegment = new ArrayList<T>(priorSegment.size() + segment.size());
                combinedSegment.addAll(priorSegment);
                combinedSegment.addAll(segment);
                masterList2.set(index, combinedSegment);
                masterList2.remove(index + 1);
                ArrayList<T> newFinalSegment = new ArrayList<T>();
                newFinalSegment.add(item);
                masterList2.add(newFinalSegment);
                return new ZenoChain<T>(masterList2);
            }
            segment = priorSegment;
        }
    }

    public ZenoChain<T> prepend(T item) {
        ArrayList<ArrayList<T>> masterList2 = new ArrayList<ArrayList<T>>(this.masterList);
        if (masterList2.isEmpty()) {
            return this.add(item);
        }
        int threshold = 32;
        int index = 0;
        ArrayList<T> segment = masterList2.get(index);
        if (segment.size() < threshold) {
            ArrayList<T> segment2 = new ArrayList<T>(32);
            segment2.add(item);
            segment2.addAll(segment);
            masterList2.set(index, segment2);
            return new ZenoChain<T>(masterList2);
        }
        while (true) {
            threshold *= 2;
            if (++index >= masterList2.size()) {
                ArrayList<T> newInitialSegment = new ArrayList<T>();
                newInitialSegment.add(item);
                masterList2.add(0, newInitialSegment);
                return new ZenoChain<T>(masterList2);
            }
            ArrayList<T> nextSegment = masterList2.get(index);
            if (nextSegment.size() + segment.size() <= threshold) {
                ArrayList<T> combinedSegment = new ArrayList<T>();
                combinedSegment.addAll(segment);
                combinedSegment.addAll(nextSegment);
                masterList2.set(index, combinedSegment);
                masterList2.remove(index - 1);
                ArrayList<T> newInitialSegment = new ArrayList<T>();
                newInitialSegment.add(item);
                masterList2.add(0, newInitialSegment);
                return new ZenoChain<T>(masterList2);
            }
            segment = nextSegment;
        }
    }

    public ZenoChain<T> addAll(Iterable<? extends T> items) {
        ZenoChain<T> result = this;
        for (T item : items) {
            result = result.add(item);
        }
        return result;
    }

    public ZenoChain<T> concat(ZenoChain<T> other) {
        ArrayList<ArrayList<T>> newMaster = new ArrayList<ArrayList<T>>(this.masterList.size() + other.masterList.size());
        newMaster.addAll(this.masterList);
        newMaster.addAll(other.masterList);
        return super.reorganize();
    }

    public ZenoChain<T> replace(int n, T value) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative");
        }
        int offset = 0;
        ArrayList<ArrayList<T>> masterList2 = new ArrayList<ArrayList<T>>(this.masterList.size());
        boolean done = false;
        for (ArrayList<T> segment : this.masterList) {
            if (offset + segment.size() > n && !done) {
                ArrayList<T> replacementSegment = new ArrayList<T>(segment.size());
                replacementSegment.addAll(segment.subList(0, n - offset));
                replacementSegment.add(value);
                replacementSegment.addAll(segment.subList(n - offset + 1, segment.size()));
                masterList2.add(replacementSegment);
                done = true;
            } else {
                masterList2.add(segment);
            }
            offset += segment.size();
        }
        if (!done) {
            throw new IndexOutOfBoundsException("Index " + n + " is too large");
        }
        return new ZenoChain<T>(masterList2);
    }

    public ZenoChain<T> remove(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative");
        }
        int offset = 0;
        ArrayList<ArrayList<T>> masterList2 = new ArrayList<ArrayList<T>>(this.masterList.size());
        boolean done = false;
        for (ArrayList<T> segment : this.masterList) {
            if (offset + segment.size() > n && !done) {
                if (segment.size() > 1) {
                    ArrayList<T> replacementSegment = new ArrayList<T>(segment.size() - 1);
                    replacementSegment.addAll(segment.subList(0, n - offset));
                    replacementSegment.addAll(segment.subList(n - offset + 1, segment.size()));
                    masterList2.add(replacementSegment);
                }
                done = true;
            } else {
                masterList2.add(segment);
            }
            offset += segment.size();
        }
        if (!done) {
            throw new IndexOutOfBoundsException("Index " + n + " is too large");
        }
        return new ZenoChain<T>(masterList2);
    }

    public ZenoChain<T> insert(int n, T value) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative");
        }
        if (n == 0) {
            return this.prepend(value);
        }
        int length = this.size();
        if (n == length) {
            return this.add(value);
        }
        if (n > length) {
            throw new IndexOutOfBoundsException("Index " + n + " is too large");
        }
        int offset = 0;
        ArrayList<ArrayList<T>> masterList2 = new ArrayList<ArrayList<T>>(this.masterList.size());
        boolean done = false;
        for (ArrayList<T> segment : this.masterList) {
            if (offset + segment.size() > n && !done) {
                ArrayList<T> replacementSegment = new ArrayList<T>(segment.size() + 1);
                replacementSegment.addAll(segment.subList(0, n - offset));
                replacementSegment.add(value);
                replacementSegment.addAll(segment.subList(n - offset, segment.size()));
                masterList2.add(replacementSegment);
                done = true;
            } else {
                masterList2.add(segment);
            }
            offset += segment.size();
        }
        if (!done) {
            throw new IndexOutOfBoundsException("Index " + n + " is too large");
        }
        return new ZenoChain<T>(masterList2);
    }

    private ZenoChain<T> reorganize() {
        for (int i2 = this.masterList.size() - 2; i2 >= 1; --i2) {
            int priorSize = this.masterList.get(i2 - 1).size();
            int segSize = this.masterList.get(i2).size();
            int nextSize = this.masterList.get(i2 + 1).size();
            if (segSize > priorSize || segSize > nextSize) continue;
            ArrayList combinedSegment = new ArrayList(priorSize + segSize);
            combinedSegment.addAll(this.masterList.get(i2 - 1));
            combinedSegment.addAll(this.masterList.get(i2));
            this.masterList.set(i2 - 1, combinedSegment);
            this.masterList.remove(i2);
        }
        return new ZenoChain<T>(this.masterList);
    }

    public T get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative");
        }
        int offset = 0;
        for (ArrayList<T> segment : this.masterList) {
            if (offset + segment.size() > n) {
                return segment.get(n - offset);
            }
            offset += segment.size();
        }
        throw new IndexOutOfBoundsException("Index " + n + " is too large");
    }

    /*
     * Enabled aggressive block sorting
     */
    public ZenoChain<T> subList(int start, int end) {
        if (start < 0 || start > end) {
            throw new IndexOutOfBoundsException("start position for subList is out of range");
        }
        ArrayList<ArrayList<T>> newMaster = new ArrayList<ArrayList<T>>();
        int offset = 0;
        int remainingLength = end - start;
        boolean active = false;
        for (ArrayList<T> segment : this.masterList) {
            if (active) {
                if (remainingLength <= segment.size()) {
                    newMaster.add(new ArrayList<T>(segment.subList(0, remainingLength)));
                    return new ZenoChain<T>(newMaster);
                }
                remainingLength -= segment.size();
                newMaster.add(segment);
            } else if (offset + segment.size() > start) {
                int localStart = start - offset;
                if (remainingLength <= segment.size() - localStart) {
                    newMaster.add(new ArrayList<T>(segment.subList(localStart, localStart + remainingLength)));
                    return new ZenoChain<T>(newMaster);
                }
                if (start == 1 && segment.size() > 128) {
                    newMaster.add(new ArrayList<T>(segment.subList(localStart, localStart + 64)));
                    newMaster.add(new ArrayList<T>(segment.subList(localStart + 64, segment.size())));
                } else {
                    newMaster.add(new ArrayList<T>(segment.subList(localStart, segment.size())));
                }
                remainingLength -= segment.size() - localStart;
                active = true;
            } else if (remainingLength == 0) break;
            offset += segment.size();
        }
        if (remainingLength > 0) {
            throw new IndexOutOfBoundsException("end position for subList is out of range");
        }
        return new ZenoChain<T>(newMaster);
    }

    public int size() {
        int total = 0;
        for (ArrayList<T> segment : this.masterList) {
            total += segment.size();
        }
        return total;
    }

    public boolean isEmpty() {
        return this.masterList.isEmpty() || this.masterList.size() == 1 && this.masterList.get(0).isEmpty();
    }

    public boolean isSingleton() {
        return this.masterList.size() == 1 && this.masterList.get(0).size() == 1;
    }

    @Override
    public Iterator<T> iterator() {
        return new ZenoChainIterator(this.masterList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (List list : this.masterList) {
            sb.append("(");
            for (Object item : list) {
                sb.append(item).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public String showMetrics() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (List list : this.masterList) {
            sb.append(list.size()).append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }
}

