/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.IntPredicate;
import net.sf.saxon.serialize.UTF8Writer;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Slice8
extends UnicodeString {
    private final byte[] bytes;
    private final int start;
    private final int end;
    private int cachedHash;

    public Slice8(byte[] bytes, int start, int end) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
    }

    @Override
    public long length() {
        return this.end - this.start;
    }

    @Override
    public int getWidth() {
        return 8;
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        if (codePoint > 255) {
            return -1L;
        }
        byte b = (byte)(codePoint & 0xFF);
        for (int i2 = this.start + Slice8.requireNonNegativeInt(from); i2 < this.end; ++i2) {
            if (this.bytes[i2] != b) continue;
            return i2 - this.start;
        }
        return -1L;
    }

    @Override
    public int codePointAt(long index) {
        int index32 = Slice8.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.start + index32] & 0xFF;
    }

    @Override
    public UnicodeString substring(long start, long end) {
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        return new Slice8(this.bytes, Slice8.requireInt(start) + this.start, Slice8.requireInt(end) + this.start);
    }

    private void write(Writer writer, long start, long len) throws IOException {
        if (writer instanceof UTF8Writer) {
            ((UTF8Writer)writer).writeLatin1(this.bytes, this.start + Slice8.requireInt(start), Slice8.requireInt(len));
        } else {
            writer.write(this.substring(Slice8.requireInt(start), Slice8.requireInt(start + len)).toString());
        }
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        for (int i2 = Slice8.requireNonNegativeInt(from) + this.start; i2 < this.end; ++i2) {
            if (!predicate.test(this.bytes[i2] & 0xFF)) continue;
            return i2 - this.start;
        }
        return -1L;
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i;
            {
                this.i = Slice8.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.i < Slice8.this.end;
            }

            @Override
            public int next() {
                return Slice8.this.bytes[this.i++] & 0xFF;
            }
        };
    }

    @Override
    void copy8bit(byte[] target, int offset) {
        System.arraycopy(this.bytes, this.start, target, offset, this.end - this.start);
    }

    @Override
    void copy16bit(char[] target, int offset) {
        int i2 = this.start;
        int j = offset;
        while (i2 < this.end) {
            target[j++] = (char)(this.bytes[i2++] & 0xFF);
        }
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        int i2 = this.start;
        int j = offset;
        while (i2 < this.end) {
            target[j++] = 0;
            target[j++] = 0;
            target[j++] = this.bytes[i2++];
        }
    }

    @Override
    void copy32bit(int[] target, int offset) {
        int i2 = this.start;
        int j = offset;
        while (i2 < this.end) {
            target[j++] = this.bytes[i2++] & 0xFF;
        }
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h = 0;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            byte b = this.bytes[i2];
            h = 31 * h + (b & 0xFF);
        }
        this.cachedHash = h;
        return this.cachedHash;
    }

    public String toString() {
        return new String(this.bytes, this.start, this.end - this.start, StandardCharsets.ISO_8859_1);
    }
}

