/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher;
import org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.apache.camel.component.spring.ws.type.EndpointMappingKey;
import org.apache.camel.component.spring.ws.type.EndpointMappingType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.xpath.XPathExpression;

@UriParams
public class SpringWebserviceConfiguration {
    @UriPath(label="producer")
    private String webServiceEndpointUri;
    @UriParam
    private MessageFilter messageFilter;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="common")
    private MessageIdStrategy messageIdStrategy;
    @UriParam(label="producer")
    private WebServiceTemplate webServiceTemplate;
    @UriParam(label="producer")
    private WebServiceMessageSender messageSender;
    @UriParam(label="producer")
    private WebServiceMessageFactory messageFactory;
    @UriParam(label="producer")
    private String soapAction;
    @UriParam(label="producer")
    private URI wsAddressingAction;
    @UriParam(label="producer")
    private URI outputAction;
    @UriParam(label="producer")
    private URI faultAction;
    @UriParam(label="producer")
    private URI faultTo;
    @UriParam(label="producer")
    private URI replyTo;
    @UriParam(label="producer")
    private int timeout = -1;
    @UriParam(label="producer")
    private boolean allowResponseHeaderOverride;
    @UriParam(label="producer")
    private boolean allowResponseAttachmentOverride;
    @UriPath(label="consumer", name="type")
    private EndpointMappingType endpointMappingType;
    @UriPath(label="consumer", name="lookupKey")
    private String endpointMappingLookupKey;
    @UriParam(label="consumer")
    private String expression;
    private transient XPathExpression xPathExpression;
    @UriParam(label="consumer")
    private CamelSpringWSEndpointMapping endpointMapping;
    @UriParam(label="consumer")
    private CamelEndpointDispatcher endpointDispatcher;

    public WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.webServiceTemplate = webServiceTemplate;
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public String getWebServiceEndpointUri() {
        return this.webServiceEndpointUri;
    }

    public void setWebServiceEndpointUri(String webServiceEndpointUri) {
        this.webServiceEndpointUri = webServiceEndpointUri;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getEndpointUri() {
        if (this.getEndpointMappingKey() != null) {
            return SpringWebserviceConfiguration.encode(this.getEndpointMappingKey().getLookupKey());
        }
        if (this.webServiceTemplate != null) {
            return this.webServiceTemplate.getDefaultUri();
        }
        return null;
    }

    public URI getWsAddressingAction() {
        return this.wsAddressingAction;
    }

    public void setWsAddressingAction(URI wsAddressingAction) {
        this.wsAddressingAction = wsAddressingAction;
    }

    public void setWsAddressingAction(String wsAddressingAction) throws URISyntaxException {
        if (StringUtils.hasText(wsAddressingAction)) {
            this.setWsAddressingAction(new URI(wsAddressingAction));
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public CamelSpringWSEndpointMapping getEndpointMapping() {
        return this.endpointMapping;
    }

    public void setEndpointMapping(CamelSpringWSEndpointMapping endpointMapping) {
        this.endpointMapping = endpointMapping;
    }

    public EndpointMappingKey getEndpointMappingKey() {
        if (this.endpointMappingType != null && this.endpointMappingLookupKey != null) {
            return new EndpointMappingKey(this.endpointMappingType, this.endpointMappingLookupKey, this.xPathExpression);
        }
        return null;
    }

    public EndpointMappingType getEndpointMappingType() {
        return this.endpointMappingType;
    }

    public void setEndpointMappingType(EndpointMappingType endpointMappingType) {
        this.endpointMappingType = endpointMappingType;
    }

    public String getEndpointMappingLookupKey() {
        return this.endpointMappingLookupKey;
    }

    public void setEndpointMappingLookupKey(String endpointMappingLookupKey) {
        this.endpointMappingLookupKey = endpointMappingLookupKey;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public CamelEndpointDispatcher getEndpointDispatcher() {
        return this.endpointDispatcher;
    }

    public void setEndpointDispatcher(CamelEndpointDispatcher endpointDispatcher) {
        this.endpointDispatcher = endpointDispatcher;
    }

    public static String encode(String uri) {
        int i2 = uri.lastIndexOf(125);
        return i2 == -1 ? uri : (String.valueOf(uri.subSequence(0, i2)) + ")" + uri.substring(i2 + 1)).replaceFirst("\\{", "(");
    }

    public static String decode(String uri) {
        int i2 = uri.lastIndexOf(41);
        return i2 == -1 ? uri : (String.valueOf(uri.subSequence(0, i2)) + "}" + uri.substring(i2 + 1)).replaceFirst("\\(", "{");
    }

    public void setMessageFilter(MessageFilter messageFilter) {
        this.messageFilter = messageFilter;
    }

    public MessageFilter getMessageFilter() {
        return this.messageFilter;
    }

    public URI getOutputAction() {
        return this.outputAction;
    }

    public void setOutputAction(URI outputAction) {
        this.outputAction = outputAction;
    }

    public void setOutputAction(String output) throws URISyntaxException {
        if (StringUtils.hasText(output)) {
            this.setOutputAction(new URI(output));
        }
    }

    public URI getFaultAction() {
        return this.faultAction;
    }

    public void setFaultAction(String fault) throws URISyntaxException {
        if (StringUtils.hasText(fault)) {
            this.setFaultAction(new URI(fault));
        }
    }

    public void setFaultAction(URI fault) {
        this.faultAction = fault;
    }

    public URI getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(String faultTo) throws URISyntaxException {
        if (StringUtils.hasText(faultTo)) {
            this.setFaultTo(new URI(faultTo));
        }
    }

    public void setFaultTo(URI faultTo) {
        this.faultTo = faultTo;
    }

    public URI getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyToAction) throws URISyntaxException {
        if (StringUtils.hasText(replyToAction)) {
            this.setReplyTo(new URI(replyToAction));
        }
    }

    public void setReplyTo(URI replyToAction) {
        this.replyTo = replyToAction;
    }

    public WebServiceMessageSender getMessageSender() {
        return this.messageSender;
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public MessageIdStrategy getMessageIdStrategy() {
        return this.messageIdStrategy;
    }

    public void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        this.messageIdStrategy = messageIdStrategy;
    }

    public boolean isAllowResponseHeaderOverride() {
        return this.allowResponseHeaderOverride;
    }

    public void setAllowResponseHeaderOverride(boolean allowResponseHeaderOverride) {
        this.allowResponseHeaderOverride = allowResponseHeaderOverride;
    }

    public boolean isAllowResponseAttachmentOverride() {
        return this.allowResponseAttachmentOverride;
    }

    public void setAllowResponseAttachmentOverride(boolean allowResponseAttachmentOverride) {
        this.allowResponseAttachmentOverride = allowResponseAttachmentOverride;
    }
}

