/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.xslt.SourceHandlerFactory;
import org.apache.camel.support.builder.xml.XMLConverterHelper;
import org.w3c.dom.Node;

public class XmlSourceHandlerFactoryImpl
implements SourceHandlerFactory {
    private XMLConverterHelper converter = new XMLConverterHelper();
    private boolean isFailOnNullBody = true;

    public boolean isFailOnNullBody() {
        return this.isFailOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.isFailOnNullBody = failOnNullBody;
    }

    @Override
    public Source getSource(Exchange exchange2) throws Exception {
        if (this.isInputStreamNeeded(exchange2)) {
            InputStream is = exchange2.getIn().getBody(InputStream.class);
            return this.getSource(exchange2, is);
        }
        Object body2 = exchange2.getIn().getBody();
        return this.getSource(exchange2, body2);
    }

    protected boolean isInputStreamNeeded(Exchange exchange2) {
        Object body2 = exchange2.getIn().getBody();
        if (body2 == null) {
            return false;
        }
        if (body2 instanceof InputStream) {
            return true;
        }
        if (body2 instanceof Source) {
            return false;
        }
        if (body2 instanceof String) {
            return false;
        }
        if (body2 instanceof byte[]) {
            return false;
        }
        if (body2 instanceof Node) {
            return false;
        }
        return exchange2.getContext().getTypeConverterRegistry().lookup(Source.class, body2.getClass()) == null;
    }

    protected Source getSource(Exchange exchange2, Object body2) {
        if (body2 instanceof Source) {
            return (Source)body2;
        }
        Source source = null;
        if (body2 != null) {
            TypeConverter tc;
            source = exchange2.getContext().getTypeConverter().tryConvertTo(SAXSource.class, exchange2, body2);
            if (source == null) {
                source = exchange2.getContext().getTypeConverter().tryConvertTo(StreamSource.class, exchange2, body2);
            }
            if (source == null) {
                source = exchange2.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange2, body2);
            }
            if (source == null && (tc = exchange2.getContext().getTypeConverterRegistry().lookup(Source.class, body2.getClass())) != null) {
                source = tc.convertTo(Source.class, exchange2, body2);
            }
        }
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange2, Source.class);
            }
            try {
                source = this.converter.toDOMSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException | TransformerException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }
}

