/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Tracer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracer
extends ServiceSupport
implements CamelContextAware,
Tracer {
    private static final String TRACING_OUTPUT = "%-4.4s [%-12.12s] [%-33.33s]";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.camel.Tracing");
    private String tracingFormat = "%-4.4s [%-12.12s] [%-33.33s]";
    private CamelContext camelContext;
    private boolean enabled = true;
    private boolean standby;
    private boolean traceRests;
    private boolean traceTemplates;
    private long traceCounter;
    private ExchangeFormatter exchangeFormatter;
    private String tracePattern;
    private transient String[] patterns;
    private boolean traceBeforeAndAfterRoute = true;

    public DefaultTracer() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        formatter.setShowExchangeId(true);
        formatter.setShowExchangePattern(false);
        formatter.setMultiline(false);
        formatter.setShowHeaders(true);
        formatter.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
        this.setExchangeFormatter(formatter);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void traceBeforeNode(NamedNode node, Exchange exchange2) {
        if (this.shouldTrace(node)) {
            ++this.traceCounter;
            String routeId = ExpressionBuilder.routeIdExpression().evaluate(exchange2, String.class);
            String label = URISupport.sanitizeUri(StringHelper.limitLength(node.getLabel(), 50));
            StringBuilder sb = new StringBuilder(512);
            sb.append(String.format(this.tracingFormat, "   ", routeId, label));
            sb.append(" ");
            String data = this.exchangeFormatter.format(exchange2);
            sb.append(data);
            String out = sb.toString();
            this.dumpTrace(out, node);
        }
    }

    @Override
    public void traceAfterNode(NamedNode node, Exchange exchange2) {
    }

    @Override
    public void traceSentNode(NamedNode node, Exchange exchange2, Endpoint endpoint, long elapsed) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        if (!endpoint.isRemote()) {
            return;
        }
        if (this.shouldTrace(node)) {
            boolean failed;
            EndpointServiceLocation esl;
            String routeId = ExpressionBuilder.routeIdExpression().evaluate(exchange2, String.class);
            StringBuilder sb = new StringBuilder(128);
            sb.append(String.format(this.tracingFormat, "   ", routeId, ""));
            sb.append(" ");
            StringJoiner sj = new StringJoiner(", ");
            sj.add("url=" + String.valueOf(endpoint));
            if (endpoint instanceof EndpointServiceLocation && (esl = (EndpointServiceLocation)((Object)endpoint)).getServiceUrl() != null) {
                Map<String, String> map;
                sj.add("service=" + esl.getServiceUrl());
                String protocol = esl.getServiceProtocol();
                if (protocol != null) {
                    sj.add("protocol=" + protocol);
                }
                if ((map = esl.getServiceMetadata()) != null) {
                    map.forEach((k, v) -> sj.add(k + "=" + v));
                }
            }
            String data = "Sent " + ((failed = exchange2.isFailed()) ? "failed" : "success") + " took " + TimeUtils.printDuration(elapsed, true);
            data = data + " (" + String.valueOf(sj) + ")";
            sb.append(data);
            String out = sb.toString();
            this.dumpTrace(out, node);
        }
    }

    @Override
    public void traceBeforeRoute(NamedRoute route, Exchange exchange2) {
        EndpointServiceLocation esl;
        Endpoint endpoint;
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getEndpointUrl();
        String label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(uri, 50) + "]");
        boolean original = route.getRouteId().equals(exchange2.getFromRouteId());
        String arrow = original ? "*-->" : "--->";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(this.tracingFormat, arrow, route.getRouteId(), label));
        sb.append(" ");
        Object data = this.exchangeFormatter.format(exchange2);
        String out = String.valueOf(sb) + (String)data;
        this.dumpTrace(out, route);
        if (original && (endpoint = exchange2.getFromEndpoint()) instanceof EndpointServiceLocation && (esl = (EndpointServiceLocation)((Object)endpoint)).getServiceUrl() != null) {
            Map<String, String> map;
            StringJoiner sj = new StringJoiner(", ");
            sj.add("url=" + String.valueOf(endpoint));
            sj.add("service=" + esl.getServiceUrl());
            String protocol = esl.getServiceProtocol();
            if (protocol != null) {
                sj.add("protocol=" + protocol);
            }
            if ((map = esl.getServiceMetadata()) != null) {
                map.forEach((k, v) -> sj.add(k + "=" + v));
            }
            data = "Received (" + String.valueOf(sj) + ")";
            sb = new StringBuilder();
            sb.append(String.format(this.tracingFormat, "", route.getRouteId(), ""));
            sb.append(" ");
            out = String.valueOf(sb) + (String)data;
            this.dumpTrace(out, route);
        }
    }

    @Override
    public void traceAfterRoute(NamedRoute route, Exchange exchange2) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getEndpointUrl();
        String label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(uri, 50) + "]");
        boolean original = route.getRouteId().equals(exchange2.getFromRouteId());
        String arrow = original ? "*<--" : "<---";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(this.tracingFormat, arrow, route.getRouteId(), label));
        sb.append(" ");
        String data = this.exchangeFormatter.format(exchange2);
        sb.append(data);
        String out = sb.toString();
        this.dumpTrace(out, route);
    }

    @Override
    public boolean shouldTrace(NamedNode definition) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Should trace evaluated {} -> pattern: {}", (Object)definition.getId(), (Object)pattern);
        }
        return pattern;
    }

    @Override
    public long getTraceCounter() {
        return this.traceCounter;
    }

    @Override
    public void resetTraceCounter() {
        this.traceCounter = 0L;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isStandby() {
        return this.standby;
    }

    @Override
    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public boolean isTraceRests() {
        return this.traceRests;
    }

    @Override
    public void setTraceRests(boolean traceRests) {
        this.traceRests = traceRests;
    }

    @Override
    public boolean isTraceTemplates() {
        return this.traceTemplates;
    }

    @Override
    public void setTraceTemplates(boolean traceTemplates) {
        this.traceTemplates = traceTemplates;
    }

    @Override
    public String getTracePattern() {
        return this.tracePattern;
    }

    @Override
    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    @Override
    public boolean isTraceBeforeAndAfterRoute() {
        return this.traceBeforeAndAfterRoute;
    }

    @Override
    public void setTraceBeforeAndAfterRoute(boolean traceBeforeAndAfterRoute) {
        this.traceBeforeAndAfterRoute = traceBeforeAndAfterRoute;
    }

    @Override
    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    @Override
    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    protected void dumpTrace(String out, Object node) {
        String name = LoggerHelper.getLineNumberLoggerName(node);
        if (name != null) {
            Logger log = LoggerFactory.getLogger((String)name);
            log.info(out);
        } else {
            LOG.info(out);
        }
    }

    protected boolean shouldTracePattern(NamedNode definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (PatternHelper.matchPattern(id, pattern)) {
                return true;
            }
            String routeId = CamelContextHelper.getRouteId(definition);
            if (routeId == null || Objects.equals(routeId, id) || !PatternHelper.matchPattern(routeId, pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getCamelContext().getTracingLoggingFormat() != null) {
            this.tracingFormat = this.getCamelContext().getTracingLoggingFormat();
        }
    }
}

