/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RemovePropertyProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final String propertyName;

    public RemovePropertyProcessor(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            exchange2.removeProperty(this.propertyName);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "removeProperty[" + this.propertyName + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

