/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionComparator;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resequencer
extends AsyncProcessorSupport
implements Navigate<Processor>,
IdAware,
RouteIdAware,
Traceable {
    public static final long DEFAULT_BATCH_TIMEOUT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(Resequencer.class);
    private String id;
    private String routeId;
    private long batchTimeout = 1000L;
    private int batchSize = 100;
    private int outBatchSize;
    private boolean groupExchanges;
    private boolean batchConsumer;
    private boolean ignoreInvalidExchanges;
    private boolean reverse;
    private boolean allowDuplicates;
    private Predicate completionPredicate;
    private final Expression expression;
    private final CamelContext camelContext;
    private final AsyncProcessor processor;
    private final Collection<Exchange> collection;
    private ExceptionHandler exceptionHandler;
    private BatchSender sender;

    public Resequencer(CamelContext camelContext, Processor processor, Expression expression) {
        this(camelContext, processor, Resequencer.createSet(expression, false, false), expression);
    }

    public Resequencer(CamelContext camelContext, Processor processor, Expression expression, boolean allowDuplicates, boolean reverse) {
        this(camelContext, processor, Resequencer.createSet(expression, allowDuplicates, reverse), expression);
    }

    public Resequencer(CamelContext camelContext, Processor processor, Set<Exchange> collection, Expression expression) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(collection, "collection");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
        this.collection = collection;
        this.expression = expression;
        this.exceptionHandler = new LoggingExceptionHandler(camelContext, this.getClass());
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "resequencer";
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            LOG.debug("Disabling batch size, will only be triggered by timeout");
            this.batchSize = Integer.MAX_VALUE;
        } else {
            this.batchSize = batchSize;
        }
    }

    public int getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(int outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public boolean isBatchConsumer() {
        return this.batchConsumer;
    }

    public void setBatchConsumer(boolean batchConsumer) {
        this.batchConsumer = batchConsumer;
    }

    public boolean isIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(boolean ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    protected static Set<Exchange> createSet(Expression expression, boolean allowDuplicates, boolean reverse) {
        return Resequencer.createSet(new ExpressionComparator(expression), allowDuplicates, reverse);
    }

    protected static Set<Exchange> createSet(Comparator<? super Exchange> comparator, boolean allowDuplicates, boolean reverse) {
        Comparator<? super Exchange> answer = comparator;
        if (reverse) {
            answer = comparator.reversed();
        }
        if (allowDuplicates) {
            answer = answer.thenComparing((o1, o2) -> 1);
        }
        return new TreeSet<Exchange>(answer);
    }

    private boolean isInBatchCompleted(int num) {
        return num >= this.batchSize;
    }

    private boolean isOutBatchCompleted() {
        if (this.outBatchSize == 0) {
            return true;
        }
        return !this.collection.isEmpty() && this.collection.size() >= this.outBatchSize;
    }

    protected void processExchange(Exchange exchange2) {
        this.processor.process(exchange2, sync -> this.postProcess(exchange2));
    }

    protected void postProcess(Exchange exchange2) {
        if (exchange2.getException() != null) {
            this.getExceptionHandler().handleException("Error processing aggregated exchange: " + exchange2, exchange2, exchange2.getException());
        }
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
        this.sender = new BatchSender();
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.sender != null) {
            try {
                this.sender.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sender = null;
        }
        ServiceHelper.stopService((Object)this.processor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            int size;
            if (this.isBatchConsumer() && this.batchSize != (size = exchange2.getProperty(ExchangePropertyKey.BATCH_SIZE, Integer.class).intValue())) {
                this.batchSize = size;
                LOG.trace("Using batch consumer completion, so setting batch size to: {}", (Object)this.batchSize);
            }
            if (!this.isValid(exchange2)) {
                if (!this.isIgnoreInvalidExchanges()) throw new CamelExchangeException("Exchange is not valid to be used by the BatchProcessor", exchange2);
                LOG.debug("Invalid Exchange. This Exchange will be ignored: {}", (Object)exchange2);
            } else {
                this.sender.enqueueExchange(exchange2);
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    private boolean isValid(Exchange exchange2) {
        Object result = null;
        try {
            result = this.expression.evaluate(exchange2, Object.class);
        }
        catch (Exception e) {
            LOG.debug("Error evaluating expression: {}. This exception is ignored.", (Object)this.expression, (Object)e);
        }
        return result != null;
    }

    private class BatchSender
    extends Thread {
        private final Queue<Exchange> queue;
        private final Lock queueLock;
        private final AtomicBoolean exchangeEnqueued;
        private final Queue<String> completionPredicateMatched;
        private final Condition exchangeEnqueuedCondition;

        BatchSender() {
            super(Resequencer.this.camelContext.getExecutorServiceManager().resolveThreadName("Batch Sender"));
            this.queueLock = new ReentrantLock();
            this.exchangeEnqueued = new AtomicBoolean();
            this.completionPredicateMatched = new ConcurrentLinkedQueue<String>();
            this.exchangeEnqueuedCondition = this.queueLock.newCondition();
            this.queue = new LinkedList<Exchange>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.queueLock.lock();
            try {
                do {
                    try {
                        if (!this.exchangeEnqueued.get()) {
                            LOG.trace("Waiting for new exchange to arrive or batchTimeout to occur after {} ms.", (Object)Resequencer.this.batchTimeout);
                            this.exchangeEnqueuedCondition.await(Resequencer.this.batchTimeout, TimeUnit.MILLISECONDS);
                        }
                        String id = null;
                        if (!this.completionPredicateMatched.isEmpty()) {
                            id = this.completionPredicateMatched.poll();
                        }
                        if (id != null || !this.exchangeEnqueued.get()) {
                            if (id != null) {
                                LOG.trace("Collecting exchanges to be aggregated triggered by completion predicate");
                            } else {
                                LOG.trace("Collecting exchanges to be aggregated triggered by batch timeout");
                            }
                            this.drainQueueTo(Resequencer.this.collection, Resequencer.this.batchSize, id);
                        } else {
                            this.exchangeEnqueued.set(false);
                            boolean drained = false;
                            while (Resequencer.this.isInBatchCompleted(this.queue.size())) {
                                drained = true;
                                this.drainQueueTo(Resequencer.this.collection, Resequencer.this.batchSize, id);
                            }
                            if (drained) {
                                LOG.trace("Collecting exchanges to be aggregated triggered by new exchanges received");
                            }
                            if (!Resequencer.this.isOutBatchCompleted()) continue;
                        }
                        this.queueLock.unlock();
                        try {
                            try {
                                this.sendExchanges();
                            }
                            catch (Exception t) {
                                Resequencer.this.getExceptionHandler().handleException(t);
                            }
                        }
                        finally {
                            this.queueLock.lock();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (Resequencer.this.isRunAllowed());
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void drainQueueTo(Collection<Exchange> collection, int batchSize, String exchangeId) {
            Exchange e;
            for (int i2 = 0; i2 < batchSize && (e = this.queue.poll()) != null; ++i2) {
                try {
                    collection.add(e);
                }
                catch (Exception t) {
                    e.setException(t);
                }
                catch (Throwable t) {
                    Resequencer.this.getExceptionHandler().handleException("Error adding exchange", e, t);
                }
                if (exchangeId != null && exchangeId.equals(e.getExchangeId())) break;
            }
        }

        public void cancel() {
            this.interrupt();
        }

        public void enqueueExchange(Exchange exchange2) {
            LOG.debug("Received exchange to be batched: {}", (Object)exchange2);
            this.queueLock.lock();
            try {
                boolean matches;
                if (Resequencer.this.completionPredicate != null && (matches = Resequencer.this.completionPredicate.matches(exchange2))) {
                    LOG.trace("Exchange matched completion predicate: {}", (Object)exchange2);
                    this.completionPredicateMatched.add(exchange2.getExchangeId());
                }
                Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange2, true);
                this.queue.add(copy);
                this.exchangeEnqueued.set(true);
                this.exchangeEnqueuedCondition.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void sendExchanges() {
            Iterator<Exchange> iter = Resequencer.this.collection.iterator();
            while (iter.hasNext()) {
                Exchange exchange2 = iter.next();
                iter.remove();
                LOG.debug("Sending aggregated exchange: {}", (Object)exchange2);
                Resequencer.this.processExchange(exchange2);
            }
        }
    }
}

