/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;

public final class UnitOfWorkProducer
extends DefaultAsyncProducer {
    private final Producer producer;
    private final AsyncProcessor processor;

    public UnitOfWorkProducer(Producer producer) {
        super(producer.getEndpoint());
        this.producer = producer;
        CamelContext ecc = producer.getEndpoint().getCamelContext();
        this.processor = PluginHelper.getInternalProcessorFactory(ecc).addUnitOfWorkProcessorAdvice(ecc, producer, null);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        return this.processor.process(exchange2, callback);
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    @Override
    public String toString() {
        return "UnitOfWork(" + this.producer + ")";
    }
}

