/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;

public class TopicLoadBalancer
extends LoadBalancerSupport {
    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        AsyncProcessor[] processors = this.doGetProcessors();
        exchange2.getContext().getCamelContextExtension().getReactiveExecutor().schedule(new State(exchange2, callback, processors)::run);
        return false;
    }

    protected Exchange copyExchangeStrategy(Processor processor, Exchange exchange2) {
        return exchange2.copy();
    }

    protected class State {
        final Exchange exchange;
        final AsyncCallback callback;
        final AsyncProcessor[] processors;
        int index;

        public State(Exchange exchange2, AsyncCallback callback, AsyncProcessor[] processors) {
            this.exchange = exchange2;
            this.callback = callback;
            this.processors = processors;
        }

        public void run() {
            if (this.index < this.processors.length) {
                AsyncProcessor processor = this.processors[this.index++];
                Exchange copy = TopicLoadBalancer.this.copyExchangeStrategy(processor, this.exchange);
                processor.process(copy, doneSync -> this.done(copy));
            } else {
                this.callback.done(false);
            }
        }

        public void done(Exchange current) {
            if (current.getException() != null) {
                this.exchange.setException(current.getException());
                this.callback.done(false);
            } else {
                this.exchange.getContext().getCamelContextExtension().getReactiveExecutor().schedule(this::run);
            }
        }
    }
}

