/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spring.spi.TransactionRollbackException;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends RedeliveryErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionErrorHandler.class);
    private final TransactionTemplate transactionTemplate;
    private final String transactionKey;
    private final LoggingLevel rollbackLoggingLevel;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, TransactionTemplate transactionTemplate, Predicate retryWhile, ScheduledExecutorService executorService, LoggingLevel rollbackLoggingLevel, Processor onExceptionOccurredProcessor) {
        super(camelContext, output, logger, redeliveryProcessor, redeliveryPolicy, null, null, false, false, false, retryWhile, executorService, null, onExceptionOccurredProcessor);
        this.transactionTemplate = transactionTemplate;
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        this.transactionKey = ObjectHelper.getIdentityHashCode(transactionTemplate);
    }

    @Override
    public ErrorHandler clone(Processor output) {
        TransactionErrorHandler answer = new TransactionErrorHandler(this.camelContext, output, this.logger, this.redeliveryProcessor, this.redeliveryPolicy, this.transactionTemplate, this.retryWhilePolicy, this.executorService, this.rollbackLoggingLevel, this.onExceptionProcessor);
        if (this.exceptionPolicies != null) {
            answer.exceptionPolicies = this.exceptionPolicies;
        }
        return answer;
    }

    @Override
    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + TransactionErrorHandler.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + String.valueOf(this.getOutput()) + "]";
    }

    @Override
    public void process(Exchange exchange2) {
        if (this.transactionTemplate.getPropagationBehavior() != 3 && exchange2.getUnitOfWork() != null && exchange2.getUnitOfWork().isTransactedBy(this.transactionKey)) {
            this.processByErrorHandler(exchange2);
        } else {
            this.processInTransaction(exchange2);
        }
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            this.process(exchange2);
        }
        catch (Throwable e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange2) {
        String redelivered = Boolean.toString(exchange2.isExternalRedelivered());
        String ids = ExchangeHelper.logIds(exchange2);
        try {
            if (exchange2.getUnitOfWork() != null) {
                exchange2.getUnitOfWork().beginTransactedBy(this.transactionKey);
            }
            this.logTransactionBegin(redelivered, ids);
            this.doInTransactionTemplate(exchange2);
            this.logTransactionCommit(redelivered, ids);
        }
        catch (TransactionRollbackException e) {
            this.logTransactionRollback(redelivered, ids, null, true);
        }
        catch (Exception e) {
            exchange2.setException(e);
            this.logTransactionRollback(redelivered, ids, e, false);
        }
        finally {
            if (exchange2.getUnitOfWork() != null) {
                exchange2.getUnitOfWork().endTransactedBy(this.transactionKey);
            }
        }
        boolean onlyLast = exchange2.isRollbackOnlyLast();
        exchange2.setRollbackOnlyLast(false);
        if (onlyLast) {
            if (LOG.isDebugEnabled()) {
                Exception cause = exchange2.getException();
                if (cause != null) {
                    LOG.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast and caught: {}", new Object[]{this.transactionKey, redelivered, ids, cause.getMessage(), cause});
                } else {
                    LOG.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast", new Object[]{this.transactionKey, redelivered, ids});
                }
            }
            exchange2.setException(null);
        }
    }

    protected void doInTransactionTemplate(final Exchange exchange2) {
        this.transactionTemplate.execute(new TransactionCallbackWithoutResult(){

            @Override
            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionErrorHandler.this.processByErrorHandler(exchange2);
                if (exchange2.getException() != null || exchange2.isRollbackOnly() || exchange2.isRollbackOnlyLast()) {
                    RuntimeException rce = exchange2.getException() != null ? RuntimeCamelException.wrapRuntimeCamelException(exchange2.getException()) : new TransactionRollbackException();
                    if (!status.isRollbackOnly()) {
                        status.setRollbackOnly();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Throwing runtime exception to force transaction to rollback on {}", (Object)TransactionErrorHandler.this.transactionTemplate.getName());
                    }
                    throw rce;
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange2) {
        this.awaitManager.process(new AsyncProcessorSupport(){

            @Override
            public boolean process(Exchange exchange2, AsyncCallback callback) {
                return TransactionErrorHandler.super.process(exchange2, callback);
            }
        }, exchange2);
    }

    private void logTransactionBegin(String redelivered, String ids) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction begin ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
        }
    }

    private void logTransactionCommit(String redelivered, String ids) {
        if ("true".equals(redelivered) && (this.rollbackLoggingLevel == LoggingLevel.INFO || this.rollbackLoggingLevel == LoggingLevel.WARN || this.rollbackLoggingLevel == LoggingLevel.ERROR)) {
            LOG.info("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
            return;
        }
        LOG.debug("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
    }

    private void logTransactionRollback(String redelivered, String ids, Throwable e, boolean rollbackOnly) {
        if (this.rollbackLoggingLevel == LoggingLevel.OFF) {
            return;
        }
        if (this.rollbackLoggingLevel == LoggingLevel.ERROR && LOG.isErrorEnabled()) {
            if (rollbackOnly) {
                LOG.error("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                LOG.error("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.WARN && LOG.isWarnEnabled()) {
            if (rollbackOnly) {
                LOG.warn("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                LOG.warn("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.INFO && LOG.isInfoEnabled()) {
            if (rollbackOnly) {
                LOG.info("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                LOG.info("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.DEBUG && LOG.isDebugEnabled()) {
            if (rollbackOnly) {
                LOG.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                LOG.debug("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.TRACE && LOG.isTraceEnabled()) {
            if (rollbackOnly) {
                LOG.trace("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                LOG.trace("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        }
    }

    private static String propagationBehaviorToString(int propagationBehavior) {
        return switch (propagationBehavior) {
            case 2 -> "PROPAGATION_MANDATORY";
            case 6 -> "PROPAGATION_NESTED";
            case 5 -> "PROPAGATION_NEVER";
            case 4 -> "PROPAGATION_NOT_SUPPORTED";
            case 0 -> "PROPAGATION_REQUIRED";
            case 3 -> "PROPAGATION_REQUIRES_NEW";
            case 1 -> "PROPAGATION_SUPPORTS";
            default -> "UNKNOWN";
        };
    }
}

