/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.spi.BrowsableVariableRepository;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.support.service.ServiceSupport;

public abstract class AbstractVariableRepository
extends ServiceSupport
implements BrowsableVariableRepository,
CamelContextAware {
    private final Map<String, Object> variables = new ConcurrentHashMap<String, Object>(8);
    private CamelContext camelContext;
    private StreamCachingStrategy strategy;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Object getVariable(String name) {
        Object answer = this.variables.get(name);
        if (answer instanceof StreamCache) {
            StreamCache sc = (StreamCache)answer;
            sc.reset();
        }
        return answer;
    }

    @Override
    public void setVariable(String name, Object value) {
        StreamCache sc;
        if (value != null && this.strategy != null && (sc = this.convertToStreamCache(value)) != null) {
            value = sc;
        }
        if (value != null) {
            this.variables.put(name, value);
        } else {
            this.variables.remove(name);
        }
    }

    @Override
    public boolean hasVariables() {
        return !this.variables.isEmpty();
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    @Override
    public Stream<String> names() {
        return this.variables.keySet().stream();
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> map) {
        this.variables.putAll(map);
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Object removeVariable(String name) {
        if (!this.hasVariables()) {
            return null;
        }
        return this.variables.remove(name);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.camelContext != null && this.camelContext.isStreamCaching().booleanValue()) {
            this.strategy = this.camelContext.getStreamCachingStrategy();
        }
    }

    protected StreamCache convertToStreamCache(Object body2) {
        if (body2 == null) {
            return null;
        }
        if (body2 instanceof StreamCache) {
            StreamCache sc = (StreamCache)body2;
            sc.reset();
            return sc;
        }
        return this.tryStreamCache(body2);
    }

    protected StreamCache tryStreamCache(Object body2) {
        try {
            return this.strategy.cache(body2);
        }
        catch (Exception e) {
            throw new StreamCacheException(body2, (Throwable)e);
        }
    }
}

