/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertBodyProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Class<?> type;
    private final String charset;
    private final boolean mandatory;

    public ConvertBodyProcessor(Class<?> type) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = null;
        this.mandatory = true;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
        this.mandatory = true;
    }

    public ConvertBodyProcessor(Class<?> type, String charset, boolean mandatory) {
        ObjectHelper.notNull(type, "type", this);
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
        this.mandatory = mandatory;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void process(Exchange exchange2) throws Exception {
        boolean copyNeeded;
        Message old = exchange2.getMessage();
        if (old.getBody() == null) {
            return;
        }
        if (exchange2.getException() != null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = exchange2.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            exchange2.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.charset);
        }
        Object value = this.mandatory ? old.getMandatoryBody(this.type) : old.getBody(this.type);
        boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange2.getContext());
            msg.copyFromWithNewBody(old, value);
            ExchangeHelper.replaceMessage(exchange2, msg, false);
        } else {
            old.setBody(value);
        }
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange2.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)originalCharsetName);
            } else {
                exchange2.removeProperty(ExchangePropertyKey.CHARSET_NAME);
            }
        }
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange2) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange2);
        this.process(exchange2, callback);
        return callback.getFuture();
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            this.process(exchange2);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }
}

