/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.server.AbstractActionMethodEndpointMapping;
import org.springframework.ws.soap.addressing.server.annotation.Action;
import org.springframework.ws.soap.addressing.server.annotation.Address;

public class AnnotationActionEndpointMapping
extends AbstractActionMethodEndpointMapping
implements BeanPostProcessor {
    protected Class<? extends Annotation> getEndpointAnnotationType() {
        return Endpoint.class;
    }

    @Override
    protected URI getActionForMethod(Method method) {
        Action action = method.getAnnotation(Action.class);
        if (action != null && StringUtils.hasText(action.value())) {
            try {
                return new URI(action.value());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Action annotation [" + action.value() + "] on [" + method + "]");
            }
        }
        return null;
    }

    @Override
    protected URI getEndpointAddress(Object endpoint) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Class<?> endpointClass = methodEndpoint.getMethod().getDeclaringClass();
        Address address = AnnotationUtils.findAnnotation(endpointClass, Address.class);
        if (address != null && StringUtils.hasText(address.value())) {
            return this.getActionUri(address.value(), methodEndpoint);
        }
        return null;
    }

    @Override
    protected URI getResponseAction(Object endpoint, MessageAddressingProperties map) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Action action = methodEndpoint.getMethod().getAnnotation(Action.class);
        if (action != null && StringUtils.hasText(action.output())) {
            return this.getActionUri(action.output(), methodEndpoint);
        }
        return super.getResponseAction(endpoint, map);
    }

    @Override
    protected URI getFaultAction(Object endpoint, MessageAddressingProperties map) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Action action = methodEndpoint.getMethod().getAnnotation(Action.class);
        if (action != null && StringUtils.hasText(action.fault())) {
            return this.getActionUri(action.fault(), methodEndpoint);
        }
        return super.getResponseAction(endpoint, map);
    }

    private URI getActionUri(String action, MethodEndpoint methodEndpoint) {
        try {
            return new URI(action);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid Action annotation [" + action + "] on [" + methodEndpoint + "]");
        }
    }

    @Override
    public final Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public final Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (AopUtils.getTargetClass(bean2).getAnnotation(this.getEndpointAnnotationType()) != null) {
            this.registerMethods(bean2);
        }
        return bean2;
    }
}

