/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.internet;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.EncodingAware;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AsciiOutputStream;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import jakarta.mail.util.LineInputStream;
import jakarta.mail.util.StreamProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class MimeUtility {
    public static final int ALL = -1;
    private static final Map<String, Boolean> nonAsciiCharsetMap;
    private static final String WORD_SPECIALS = "=_?\"#$%&'(),.:;<>@[\\]^`{|}~";
    private static final String TEXT_SPECIALS = "=_?";
    private static final boolean decodeStrict;
    private static final boolean encodeEolStrict;
    private static final boolean ignoreUnknownEncoding;
    private static final boolean allowUtf8;
    private static final boolean foldEncodedWords;
    private static final boolean foldText;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Map<String, String> mime2java;
    private static Map<String, String> java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;

    private MimeUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEncoding(DataSource ds) {
        ContentType cType = null;
        InputStream is = null;
        String encoding = null;
        if (ds instanceof EncodingAware && (encoding = ((EncodingAware)((Object)ds)).getEncoding()) != null) {
            return encoding;
        }
        try {
            cType = new ContentType(ds.getContentType());
            is = ds.getInputStream();
            boolean isText = cType.match("text/*");
            int i2 = MimeUtility.checkAscii(is, -1, !isText);
            switch (i2) {
                case 1: {
                    encoding = StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder();
                    return encoding;
                }
                case 2: {
                    if (isText && MimeUtility.nonAsciiCharset(cType)) {
                        encoding = StreamProvider.EncoderTypes.BASE_64.getEncoder();
                        return encoding;
                    } else {
                        encoding = StreamProvider.EncoderTypes.QUOTED_PRINTABLE_ENCODER.getEncoder();
                        return encoding;
                    }
                }
                default: {
                    encoding = StreamProvider.EncoderTypes.BASE_64.getEncoder();
                    return encoding;
                }
            }
        }
        catch (Exception ex) {
            String string = StreamProvider.EncoderTypes.BASE_64.getEncoder();
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean nonAsciiCharset(ContentType ct) {
        Boolean bool;
        String charset = ct.getParameter("charset");
        if (charset == null) {
            return false;
        }
        charset = charset.toLowerCase(Locale.ENGLISH);
        Map<String, Boolean> map = nonAsciiCharsetMap;
        synchronized (map) {
            bool = nonAsciiCharsetMap.get(charset);
        }
        if (bool == null) {
            try {
                byte[] b = "\r\n".getBytes(charset);
                bool = b.length != 2 || b[0] != 13 || b[1] != 10;
            }
            catch (UnsupportedEncodingException uex) {
                bool = Boolean.FALSE;
            }
            catch (RuntimeException ex) {
                bool = Boolean.TRUE;
            }
            map = nonAsciiCharsetMap;
            synchronized (map) {
                nonAsciiCharsetMap.put(charset, bool);
            }
        }
        return bool;
    }

    public static String getEncoding(DataHandler dh) {
        ContentType cType = null;
        String encoding = null;
        if (dh.getName() != null) {
            return MimeUtility.getEncoding(dh.getDataSource());
        }
        try {
            cType = new ContentType(dh.getContentType());
        }
        catch (Exception ex) {
            return StreamProvider.EncoderTypes.BASE_64.getEncoder();
        }
        if (cType.match("text/*")) {
            AsciiOutputStream aos = new AsciiOutputStream(false, false);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            switch (aos.getAscii()) {
                case 1: {
                    encoding = StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder();
                    break;
                }
                case 2: {
                    encoding = StreamProvider.EncoderTypes.QUOTED_PRINTABLE_ENCODER.getEncoder();
                    break;
                }
                default: {
                    encoding = StreamProvider.EncoderTypes.BASE_64.getEncoder();
                    break;
                }
            }
        } else {
            AsciiOutputStream aos = new AsciiOutputStream(true, encodeEolStrict);
            try {
                dh.writeTo(aos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            encoding = aos.getAscii() == 1 ? StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder() : StreamProvider.EncoderTypes.BASE_64.getEncoder();
        }
        return encoding;
    }

    public static InputStream decode(InputStream is, String encoding) throws MessagingException {
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BASE_64.getEncoder())) {
            return StreamProvider.provider().inputBase64(is);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.QUOTED_PRINTABLE_ENCODER.getEncoder())) {
            return StreamProvider.provider().inputQP(is);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UUE.getEncoder())) {
            return StreamProvider.provider().inputUU(is);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BINARY_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT8_ENCODER.getEncoder())) {
            return StreamProvider.provider().inputBinary(is);
        }
        if (!ignoreUnknownEncoding) {
            throw new MessagingException("Unknown encoding: " + encoding);
        }
        return is;
    }

    public static OutputStream encode(OutputStream os, String encoding) throws MessagingException {
        if (encoding == null) {
            return os;
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BASE_64.getEncoder())) {
            return StreamProvider.provider().outputBase64(os);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.QUOTED_PRINTABLE_ENCODER.getEncoder())) {
            return StreamProvider.provider().outputQP(os);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UUE.getEncoder())) {
            return StreamProvider.provider().outputUU(os, null);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BINARY_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT8_ENCODER.getEncoder())) {
            return StreamProvider.provider().outputBinary(os);
        }
        throw new MessagingException("Unknown encoding: " + encoding);
    }

    public static OutputStream encode(OutputStream os, String encoding, String filename) throws MessagingException {
        if (encoding == null) {
            return os;
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BASE_64.getEncoder())) {
            return StreamProvider.provider().outputBase64(os);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.QUOTED_PRINTABLE_ENCODER.getEncoder())) {
            return StreamProvider.provider().outputQP(os);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UU_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.X_UUE.getEncoder())) {
            return StreamProvider.provider().outputUU(os, filename);
        }
        if (encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BINARY_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT7_ENCODER.getEncoder()) || encoding.equalsIgnoreCase(StreamProvider.EncoderTypes.BIT8_ENCODER.getEncoder())) {
            return StreamProvider.provider().outputBinary(os);
        }
        throw new MessagingException("Unknown encoding: " + encoding);
    }

    public static String encodeText(String text) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(text, null, null);
    }

    public static String encodeText(String text, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, charset, encoding, false);
    }

    public static String decodeText(String etext) throws UnsupportedEncodingException {
        String lwsp = " \t\n\r";
        if (!etext.contains("=?")) {
            return etext;
        }
        StringTokenizer st = new StringTokenizer(etext, lwsp, true);
        StringBuilder sb = new StringBuilder();
        StringBuilder wsb = new StringBuilder();
        boolean prevWasEncoded = false;
        while (st.hasMoreTokens()) {
            String word;
            String s = st.nextToken();
            char c = s.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                wsb.append(c);
                continue;
            }
            try {
                word = MimeUtility.decodeWord(s);
                if (!prevWasEncoded && wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = true;
            }
            catch (ParseException pex) {
                word = s;
                if (!decodeStrict) {
                    String dword = MimeUtility.decodeInnerWords(word);
                    if (dword != word) {
                        if (!(prevWasEncoded && word.startsWith("=?") || wsb.length() <= 0)) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = word.endsWith("?=");
                        word = dword;
                    } else {
                        if (wsb.length() > 0) {
                            sb.append((CharSequence)wsb);
                        }
                        prevWasEncoded = false;
                    }
                }
                if (wsb.length() > 0) {
                    sb.append((CharSequence)wsb);
                }
                prevWasEncoded = false;
            }
            sb.append(word);
            wsb.setLength(0);
        }
        sb.append((CharSequence)wsb);
        return sb.toString();
    }

    public static String encodeWord(String word) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, null, null);
    }

    public static String encodeWord(String word, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, charset, encoding, true);
    }

    private static String encodeWord(String string, String charset, String encoding, boolean encodingWord) throws UnsupportedEncodingException {
        boolean b64;
        String jcharset;
        int ascii = MimeUtility.checkAscii(string);
        if (ascii == 1) {
            return string;
        }
        if (charset == null) {
            jcharset = MimeUtility.getDefaultJavaCharset();
            charset = MimeUtility.getDefaultMIMECharset();
        } else {
            jcharset = MimeUtility.javaCharset(charset);
        }
        if (encoding == null) {
            encoding = ascii != 3 ? "Q" : "B";
        }
        if (encoding.equalsIgnoreCase("B")) {
            b64 = true;
        } else if (encoding.equalsIgnoreCase("Q")) {
            b64 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + encoding);
        }
        StringBuilder outb = new StringBuilder();
        MimeUtility.doEncode(string, b64, jcharset, 68 - charset.length(), "=?" + charset + "?" + encoding + "?", true, encodingWord, outb);
        return outb.toString();
    }

    private static int bEncodedLength(byte[] b) {
        return (b.length + 2) / 3 * 4;
    }

    private static int qEncodedLength(byte[] b, boolean encodingWord) {
        int len = 0;
        String specials = encodingWord ? WORD_SPECIALS : TEXT_SPECIALS;
        for (int i2 = 0; i2 < b.length; ++i2) {
            int c = b[i2] & 0xFF;
            if (c < 32 || c >= 127 || specials.indexOf(c) >= 0) {
                len += 3;
                continue;
            }
            ++len;
        }
        return len;
    }

    private static void doEncode(String string, boolean b64, String jcharset, int avail, String prefix, boolean first, boolean encodingWord, StringBuilder buf) throws UnsupportedEncodingException {
        int size;
        byte[] bytes = string.getBytes(jcharset);
        int len = b64 ? MimeUtility.bEncodedLength(bytes) : MimeUtility.qEncodedLength(bytes, encodingWord);
        if (len > avail && (size = string.length()) > 1) {
            int split = size / 2;
            if (Character.isHighSurrogate(string.charAt(split - 1))) {
                --split;
            }
            if (split > 0) {
                MimeUtility.doEncode(string.substring(0, split), b64, jcharset, avail, prefix, first, encodingWord, buf);
            }
            MimeUtility.doEncode(string.substring(split, size), b64, jcharset, avail, prefix, false, encodingWord, buf);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStream eos = b64 ? StreamProvider.provider().outputB(os) : StreamProvider.provider().outputQ(os, encodingWord);
            try {
                eos.write(bytes);
                eos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] encodedBytes = os.toByteArray();
            if (!first) {
                if (foldEncodedWords) {
                    buf.append("\r\n ");
                } else {
                    buf.append(" ");
                }
            }
            buf.append(prefix);
            for (int i2 = 0; i2 < encodedBytes.length; ++i2) {
                buf.append((char)encodedBytes[i2]);
            }
            buf.append("?=");
        }
    }

    public static String decodeWord(String eword) throws ParseException, UnsupportedEncodingException {
        if (!eword.startsWith("=?")) {
            throw new ParseException("encoded word does not start with \"=?\": " + eword);
        }
        int start = 2;
        int pos = eword.indexOf(63, start);
        if (pos == -1) {
            throw new ParseException("encoded word does not include charset: " + eword);
        }
        String charset = eword.substring(start, pos);
        int lpos = charset.indexOf(42);
        if (lpos >= 0) {
            charset = charset.substring(0, lpos);
        }
        charset = MimeUtility.javaCharset(charset);
        start = pos + 1;
        if ((pos = eword.indexOf(63, start)) == -1) {
            throw new ParseException("encoded word does not include encoding: " + eword);
        }
        String encoding = eword.substring(start, pos);
        start = pos + 1;
        if ((pos = eword.indexOf("?=", start)) == -1) {
            throw new ParseException("encoded word does not end with \"?=\": " + eword);
        }
        String word = eword.substring(start, pos);
        try {
            String decodedWord;
            if (word.length() > 0) {
                InputStream is;
                ByteArrayInputStream bis = new ByteArrayInputStream(MimeUtility.getBytes(word));
                if (encoding.equalsIgnoreCase("B")) {
                    is = StreamProvider.provider().inputBase64(bis);
                } else if (encoding.equalsIgnoreCase("Q")) {
                    is = StreamProvider.provider().inputQ(bis);
                } else {
                    throw new UnsupportedEncodingException("unknown encoding: " + encoding);
                }
                int count = bis.available();
                byte[] bytes = new byte[count];
                count = is.read(bytes, 0, count);
                decodedWord = count <= 0 ? "" : new String(bytes, 0, count, charset);
            } else {
                decodedWord = "";
            }
            if (pos + 2 < eword.length()) {
                String rest = eword.substring(pos + 2);
                if (!decodeStrict) {
                    rest = MimeUtility.decodeInnerWords(rest);
                }
                decodedWord = decodedWord + rest;
            }
            return decodedWord;
        }
        catch (UnsupportedEncodingException uex) {
            throw uex;
        }
        catch (IOException ioex) {
            throw new ParseException(ioex.toString());
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(charset);
        }
    }

    private static String decodeInnerWords(String word) throws UnsupportedEncodingException {
        int i2;
        int start = 0;
        StringBuilder buf = new StringBuilder();
        while ((i2 = word.indexOf("=?", start)) >= 0) {
            buf.append(word, start, i2);
            int end = word.indexOf(63, i2 + 2);
            if (end < 0 || (end = word.indexOf(63, end + 1)) < 0 || (end = word.indexOf("?=", end + 1)) < 0) break;
            String s = word.substring(i2, end + 2);
            try {
                s = MimeUtility.decodeWord(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            buf.append(s);
            start = end + 2;
        }
        if (start == 0) {
            return word;
        }
        if (start < word.length()) {
            buf.append(word.substring(start));
        }
        return buf.toString();
    }

    public static String quote(String word, String specials) {
        int len;
        int n = len = word == null ? 0 : word.length();
        if (len == 0) {
            return "\"\"";
        }
        boolean needQuoting = false;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = word.charAt(i2);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuilder sb = new StringBuilder(len + 3);
                sb.append('\"');
                sb.append(word, 0, i2);
                int lastc = 0;
                for (int j = i2; j < len; ++j) {
                    char cc = word.charAt(j);
                    if (!(cc != '\"' && cc != '\\' && cc != '\r' && cc != '\n' || cc == '\n' && lastc == 13)) {
                        sb.append('\\');
                    }
                    sb.append(cc);
                    lastc = cc;
                }
                sb.append('\"');
                return sb.toString();
            }
            if (c >= ' ' && (c < '\u007f' || allowUtf8) && specials.indexOf(c) < 0) continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append('\"').append(word).append('\"');
            return sb.toString();
        }
        return word;
    }

    public static String fold(int used, String s) {
        char c;
        int end;
        if (!foldText) {
            return s;
        }
        for (end = s.length() - 1; end >= 0 && ((c = s.charAt(end)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --end) {
        }
        if (end != s.length() - 1) {
            s = s.substring(0, end + 1);
        }
        if (used + s.length() <= 76) {
            return MimeUtility.makesafe(s);
        }
        StringBuilder sb = new StringBuilder(s.length() + 4);
        char lastc = '\u0000';
        while (used + s.length() > 76) {
            int lastspace = -1;
            for (int i2 = 0; i2 < s.length() && (lastspace == -1 || used + i2 <= 76); ++i2) {
                c = s.charAt(i2);
                if ((c == ' ' || c == '\t') && lastc != ' ' && lastc != '\t') {
                    lastspace = i2;
                }
                lastc = c;
            }
            if (lastspace == -1) {
                sb.append(s);
                s = "";
                used = 0;
                break;
            }
            sb.append(s, 0, lastspace);
            sb.append("\r\n");
            lastc = s.charAt(lastspace);
            sb.append(lastc);
            s = s.substring(lastspace + 1);
            used = 1;
        }
        sb.append(s);
        return MimeUtility.makesafe(sb);
    }

    private static String makesafe(CharSequence s) {
        char c;
        int i2;
        for (i2 = 0; i2 < s.length() && (c = s.charAt(i2)) != '\r' && c != '\n'; ++i2) {
        }
        if (i2 == s.length()) {
            return s.toString();
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        BufferedReader r = new BufferedReader(new StringReader(s.toString()));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                    assert (line.length() > 0);
                    char c2 = line.charAt(0);
                    if (c2 != ' ' && c2 != '\t') {
                        sb.append(' ');
                    }
                }
                sb.append(line);
            }
        }
        catch (IOException ex) {
            return s.toString();
        }
        return sb.toString();
    }

    public static String unfold(String s) {
        int i2;
        if (!foldText) {
            return s;
        }
        StringBuilder sb = null;
        while ((i2 = MimeUtility.indexOfAny(s, "\r\n")) >= 0) {
            char c;
            int start = i2++;
            int slen = s.length();
            if (i2 < slen && s.charAt(i2 - 1) == '\r' && s.charAt(i2) == '\n') {
                ++i2;
            }
            if (start > 0 && s.charAt(start - 1) == '\\') {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s, 0, start - 1);
                sb.append(s, start, i2);
                s = s.substring(i2);
                continue;
            }
            if (i2 >= slen || (c = s.charAt(i2)) == ' ' || c == '\t') {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                }
                sb.append(s, 0, start);
                s = s.substring(i2);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s.length());
            }
            sb.append(s, 0, i2);
            s = s.substring(i2);
        }
        if (sb != null) {
            sb.append(s);
            return sb.toString();
        }
        return s;
    }

    private static int indexOfAny(String s, String any) {
        return MimeUtility.indexOfAny(s, any, 0);
    }

    private static int indexOfAny(String s, String any, int start) {
        try {
            int len = s.length();
            for (int i2 = start; i2 < len; ++i2) {
                if (any.indexOf(s.charAt(i2)) < 0) continue;
                return i2;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public static String javaCharset(String charset) {
        if (mime2java == null || charset == null) {
            return charset;
        }
        String alias = mime2java.get(charset.toLowerCase(Locale.ENGLISH));
        if (alias != null) {
            try {
                Charset.forName(alias);
            }
            catch (Exception ex) {
                alias = null;
            }
        }
        return alias == null ? charset : alias;
    }

    public static String mimeCharset(String charset) {
        if (java2mime == null || charset == null) {
            return charset;
        }
        String alias = java2mime.get(charset.toLowerCase(Locale.ENGLISH));
        return alias == null ? charset : alias;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (defaultJavaCharset == null) {
                String mimecs = null;
                try {
                    mimecs = System.getProperty("mail.mime.charset");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (mimecs != null && mimecs.length() > 0) {
                    defaultJavaCharset = MimeUtility.javaCharset(mimecs);
                    return defaultJavaCharset;
                }
                try {
                    defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
                }
                catch (SecurityException sex) {
                    if (defaultJavaCharset != null) break block6;
                    defaultJavaCharset = "8859_1";
                }
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            try {
                defaultMIMECharset = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream is, Map<String, String> table) {
        while (true) {
            String currLine;
            try {
                currLine = is.readLine();
            }
            catch (IOException ioex) {
                break;
            }
            if (currLine == null || currLine.startsWith("--") && currLine.endsWith("--")) break;
            if (currLine.trim().length() == 0 || currLine.startsWith("#")) continue;
            StringTokenizer tk = new StringTokenizer(currLine, " \t");
            try {
                String key = tk.nextToken();
                String value = tk.nextToken();
                table.put(key.toLowerCase(Locale.ENGLISH), value);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String s) {
        int ascii = 0;
        int non_ascii = 0;
        int l = s.length();
        for (int i2 = 0; i2 < l; ++i2) {
            if (MimeUtility.nonascii(s.charAt(i2))) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(byte[] b) {
        int ascii = 0;
        int non_ascii = 0;
        for (int i2 = 0; i2 < b.length; ++i2) {
            if (MimeUtility.nonascii(b[i2] & 0xFF)) {
                ++non_ascii;
                continue;
            }
            ++ascii;
        }
        if (non_ascii == 0) {
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream is, int max, boolean breakOnNonAscii) {
        int ascii = 0;
        int non_ascii = 0;
        int block = 4096;
        int linelen = 0;
        boolean longLine = false;
        boolean badEOL = false;
        boolean checkEOL = encodeEolStrict && breakOnNonAscii;
        byte[] buf = null;
        if (max != 0) {
            block = max == -1 ? 4096 : Math.min(max, 4096);
            buf = new byte[block];
        }
        while (max != 0) {
            int len;
            try {
                len = is.read(buf, 0, block);
                if (len == -1) break;
                int lastb = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int b = buf[i2] & 0xFF;
                    if (checkEOL && (lastb == 13 && b != 10 || lastb != 13 && b == 10)) {
                        badEOL = true;
                    }
                    if (b == 13 || b == 10) {
                        linelen = 0;
                    } else if (++linelen > 998) {
                        longLine = true;
                    }
                    if (MimeUtility.nonascii(b)) {
                        if (breakOnNonAscii) {
                            return 3;
                        }
                        ++non_ascii;
                    } else {
                        ++ascii;
                    }
                    lastb = b;
                }
            }
            catch (IOException ioex) {
                break;
            }
            if (max == -1) continue;
            max -= len;
        }
        if (max == 0 && breakOnNonAscii) {
            return 3;
        }
        if (non_ascii == 0) {
            if (badEOL) {
                return 3;
            }
            if (longLine) {
                return 2;
            }
            return 1;
        }
        if (ascii > non_ascii) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int b) {
        return b >= 127 || b < 32 && b != 13 && b != 10 && b != 9;
    }

    public static byte[] getBytes(String s) {
        char[] chars = s.toCharArray();
        int size = chars.length;
        byte[] bytes = new byte[size];
        int i2 = 0;
        while (i2 < size) {
            bytes[i2] = (byte)chars[i2++];
        }
        return bytes;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    static boolean getBooleanProperty(Properties props, String name, boolean def) {
        return MimeUtility.getBoolean(MimeUtility.getProp(props, name), def);
    }

    static boolean getBooleanSystemProperty(String name, boolean def) {
        try {
            return MimeUtility.getBoolean(MimeUtility.getProp(System.getProperties(), name), def);
        }
        catch (SecurityException securityException) {
            try {
                String value = System.getProperty(name);
                if (value == null) {
                    return def;
                }
                if (def) {
                    return !value.equalsIgnoreCase("false");
                }
                return value.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def;
            }
        }
    }

    private static Object getProp(Properties props, String name) {
        Object val = props.get(name);
        if (val != null) {
            return val;
        }
        return props.getProperty(name);
    }

    private static boolean getBoolean(Object value, boolean def) {
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            if (def) {
                return !((String)value).equalsIgnoreCase("false");
            }
            return ((String)value).equalsIgnoreCase("true");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return def;
    }

    static {
        block11: {
            nonAsciiCharsetMap = new HashMap<String, Boolean>();
            decodeStrict = MimeUtility.getBooleanSystemProperty("mail.mime.decodetext.strict", true);
            encodeEolStrict = MimeUtility.getBooleanSystemProperty("mail.mime.encodeeol.strict", false);
            ignoreUnknownEncoding = MimeUtility.getBooleanSystemProperty("mail.mime.ignoreunknownencoding", false);
            allowUtf8 = MimeUtility.getBooleanSystemProperty("mail.mime.allowutf8", false);
            foldEncodedWords = MimeUtility.getBooleanSystemProperty("mail.mime.foldencodedwords", false);
            foldText = MimeUtility.getBooleanSystemProperty("mail.mime.foldtext", true);
            java2mime = new HashMap<String, String>(40);
            mime2java = new HashMap<String, String>(14);
            try {
                InputStream is = MimeUtility.class.getResourceAsStream("/META-INF/javamail.charset.map");
                if (is == null) break block11;
                try {
                    LineInputStream lineInput = StreamProvider.provider().inputLineStream(is, false);
                    MimeUtility.loadMappings(lineInput, java2mime);
                    MimeUtility.loadMappings(lineInput, mime2java);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (java2mime.isEmpty()) {
            java2mime.put("8859_1", "ISO-8859-1");
            java2mime.put("iso8859_1", "ISO-8859-1");
            java2mime.put("iso8859-1", "ISO-8859-1");
            java2mime.put("8859_2", "ISO-8859-2");
            java2mime.put("iso8859_2", "ISO-8859-2");
            java2mime.put("iso8859-2", "ISO-8859-2");
            java2mime.put("8859_3", "ISO-8859-3");
            java2mime.put("iso8859_3", "ISO-8859-3");
            java2mime.put("iso8859-3", "ISO-8859-3");
            java2mime.put("8859_4", "ISO-8859-4");
            java2mime.put("iso8859_4", "ISO-8859-4");
            java2mime.put("iso8859-4", "ISO-8859-4");
            java2mime.put("8859_5", "ISO-8859-5");
            java2mime.put("iso8859_5", "ISO-8859-5");
            java2mime.put("iso8859-5", "ISO-8859-5");
            java2mime.put("8859_6", "ISO-8859-6");
            java2mime.put("iso8859_6", "ISO-8859-6");
            java2mime.put("iso8859-6", "ISO-8859-6");
            java2mime.put("8859_7", "ISO-8859-7");
            java2mime.put("iso8859_7", "ISO-8859-7");
            java2mime.put("iso8859-7", "ISO-8859-7");
            java2mime.put("8859_8", "ISO-8859-8");
            java2mime.put("iso8859_8", "ISO-8859-8");
            java2mime.put("iso8859-8", "ISO-8859-8");
            java2mime.put("8859_9", "ISO-8859-9");
            java2mime.put("iso8859_9", "ISO-8859-9");
            java2mime.put("iso8859-9", "ISO-8859-9");
            java2mime.put("sjis", "Shift_JIS");
            java2mime.put("jis", "ISO-2022-JP");
            java2mime.put("iso2022jp", "ISO-2022-JP");
            java2mime.put("euc_jp", "euc-jp");
            java2mime.put("koi8_r", "koi8-r");
            java2mime.put("euc_cn", "euc-cn");
            java2mime.put("euc_tw", "euc-tw");
            java2mime.put("euc_kr", "euc-kr");
        }
        if (mime2java.isEmpty()) {
            mime2java.put("iso-2022-cn", "ISO2022CN");
            mime2java.put("iso-2022-kr", "ISO2022KR");
            mime2java.put("utf-8", "UTF8");
            mime2java.put("utf8", "UTF8");
            mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
            mime2java.put("ja_jp.eucjp", "EUCJIS");
            mime2java.put("euc-kr", "KSC5601");
            mime2java.put("euckr", "KSC5601");
            mime2java.put("us-ascii", "ISO-8859-1");
            mime2java.put("x-us-ascii", "ISO-8859-1");
            mime2java.put("gb2312", "GB18030");
            mime2java.put("cp936", "GB18030");
            mime2java.put("ms936", "GB18030");
            mime2java.put("gbk", "GB18030");
        }
    }
}

