/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.search;

import jakarta.mail.Message;
import jakarta.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    private SearchTerm[] terms;
    private static final long serialVersionUID = -3583274505380989582L;

    public AndTerm(SearchTerm t1, SearchTerm t2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = t1;
        this.terms[1] = t2;
    }

    public AndTerm(SearchTerm[] t) {
        this.terms = new SearchTerm[t.length];
        System.arraycopy(t, 0, this.terms, 0, t.length);
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    @Override
    public boolean match(Message msg) {
        for (int i2 = 0; i2 < this.terms.length; ++i2) {
            if (this.terms[i2].match(msg)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AndTerm)) {
            return false;
        }
        AndTerm at = (AndTerm)obj;
        if (at.terms.length != this.terms.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.terms.length; ++i2) {
            if (this.terms[i2].equals(at.terms[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.terms.length; ++i2) {
            hash += this.terms[i2].hashCode();
        }
        return hash;
    }
}

