/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.function.Supplier;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.TwoItemIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private final Supplier<RoleDiagnostic> roleSupplier;

    private CardinalityChecker(Expression sequence, int cardinality, Supplier<RoleDiagnostic> role) {
        super(sequence);
        this.requiredCardinality = cardinality;
        this.roleSupplier = role;
    }

    public static Expression makeCardinalityChecker(Expression sequence, int cardinality, Supplier<RoleDiagnostic> roleSupplier) {
        UnaryExpression result;
        if (sequence instanceof Literal && Cardinality.subsumes(cardinality, SequenceTool.getCardinality(((Literal)sequence).getGroundedValue()))) {
            return sequence;
        }
        if (sequence instanceof Atomizer && !Cardinality.allowsMany(cardinality)) {
            Expression base = ((Atomizer)sequence).getBaseExpression();
            result = new SingletonAtomizer(base, roleSupplier, Cardinality.allowsZero(cardinality));
        } else {
            result = new CardinalityChecker(sequence, cardinality, roleSupplier);
        }
        ExpressionTool.copyLocationInfo(sequence, result);
        return result;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().optimize(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        if ((base.getCardinality() & this.requiredCardinality) == 0) {
            RoleDiagnostic role = this.roleSupplier.get();
            throw new XPathException("The " + role.getMessage() + " does not satisfy the cardinality constraints", role.getErrorCode()).withLocation(this.getLocation()).asTypeErrorIf(role.isTypeError());
        }
        if (base instanceof ItemChecker) {
            ItemChecker checker = (ItemChecker)base;
            Expression other = checker.getBaseExpression();
            this.setBaseExpression(other);
            checker.setBaseExpression(this);
            checker.setParentExpression(null);
            return checker;
        }
        return this;
    }

    public RoleDiagnostic getRoleLocator() {
        return this.roleSupplier.get();
    }

    public Supplier<RoleDiagnostic> getRoleSupplier() {
        return this.roleSupplier;
    }

    @Override
    public int getImplementationMethod() {
        int m = 22;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            m |= 1;
        }
        return m;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        return this.checkCardinality(base, context);
    }

    public SequenceIterator checkCardinality(SequenceIterator base, XPathContext context) throws XPathException {
        if (SequenceTool.supportsGetLength(base)) {
            int count = SequenceTool.getLength(base);
            if (count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                RoleDiagnostic role = this.roleSupplier.get();
                this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), context);
            } else if (count == 1 && this.requiredCardinality == 8192) {
                RoleDiagnostic role = this.roleSupplier.get();
                this.typeError("The only value allowed for the " + role.getMessage() + " is an empty sequence", role.getErrorCode(), context);
            } else if (count > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                RoleDiagnostic role = this.roleSupplier.get();
                this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage() + CardinalityChecker.depictSequenceStart(base, 2), role.getErrorCode(), context);
            }
            return base;
        }
        try {
            return new CardinalityCheckingIterator(base, this.requiredCardinality, this.roleSupplier, this.getLocation());
        }
        catch (XPathException e) {
            throw e.maybeWithContext(context);
        }
    }

    public static String depictSequenceStart(SequenceIterator seq, int max) {
        Item next;
        StringBuilder sb = new StringBuilder(64);
        int count = 0;
        sb.append(" (");
        while ((next = seq.next()) != null) {
            if (count++ > 0) {
                sb.append(", ");
            }
            if (count > max) {
                sb.append("...) ");
                return sb.toString();
            }
            sb.append(Err.depict(next));
        }
        sb.append(") ");
        return sb.toString();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        try {
            SequenceIterator iter = this.getBaseExpression().iterate(context);
            Item first = iter.next();
            if (first == null) {
                if (!Cardinality.allowsZero(this.requiredCardinality)) {
                    RoleDiagnostic role = this.roleSupplier.get();
                    this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), context);
                }
                return null;
            }
            if (this.requiredCardinality == 8192) {
                RoleDiagnostic role = this.roleSupplier.get();
                this.typeError("An empty sequence is required as the " + role.getMessage(), role.getErrorCode(), context);
                return null;
            }
            Item second = iter.next();
            if (second != null) {
                RoleDiagnostic role = this.roleSupplier.get();
                this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage() + CardinalityChecker.depictSequenceStart(new TwoItemIterator(first, second), 2), role.getErrorCode(), context);
                return null;
            }
            return first;
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        PushEvaluator pusher = this.makeElaborator().elaborateForPush();
        TailCall tc = pusher.processLeavingTail(output, context);
        Expression.dispatchTailCall(tc);
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    protected int computeCardinality() {
        return this.requiredCardinality;
    }

    @Override
    protected int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CardinalityChecker c2 = new CardinalityChecker(this.getBaseExpression().copy(rebindings), this.requiredCardinality, this.roleSupplier);
        ExpressionTool.copyLocationInfo(this, c2);
        return c2;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredCardinality == ((CardinalityChecker)other).requiredCardinality;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.requiredCardinality;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("check", this);
        String occ = Cardinality.getOccurrenceIndicator(this.requiredCardinality);
        if (occ.equals("")) {
            occ = "1";
        }
        out.emitAttribute("card", occ);
        out.emitAttribute("diag", this.roleSupplier.get().save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    @Override
    public String toString() {
        Expression operand = this.getBaseExpression();
        switch (this.requiredCardinality) {
            case 16384: {
                return "exactly-one(" + operand + ")";
            }
            case 24576: {
                return "zero-or-one(" + operand + ")";
            }
            case 49152: {
                return "one-or-more(" + operand + ")";
            }
            case 8192: {
                return "must-be-empty(" + operand + ")";
            }
        }
        return "check(" + operand + ")";
    }

    @Override
    public String getExpressionName() {
        return "CheckCardinality";
    }

    @Override
    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    @Override
    public String getStreamerName() {
        return "CardinalityChecker";
    }

    @Override
    public void setLocation(Location id) {
        super.setLocation(id);
    }

    @Override
    public Elaborator getElaborator() {
        return new CardinalityCheckerElaborator();
    }

    public static class CardinalityCheckerElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            CardinalityChecker expr = (CardinalityChecker)this.getExpression();
            Expression arg = expr.getBaseExpression();
            PullEvaluator argEval = arg.makeElaborator().elaborateForPull();
            return context -> expr.checkCardinality(argEval.iterate(context), context);
        }

        @Override
        public PushEvaluator elaborateForPush() {
            CardinalityChecker expr = (CardinalityChecker)this.getExpression();
            Expression next = expr.getBaseExpression();
            ItemType type = Type.ITEM_TYPE;
            if (next instanceof ItemChecker) {
                type = ((ItemChecker)next).getRequiredType();
                next = ((ItemChecker)next).getBaseExpression();
            }
            if ((next.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
                ItemType finalType = type;
                PushEvaluator pushEval = next.makeElaborator().elaborateForPush();
                return (output, context) -> {
                    TypeCheckingFilter filter2 = new TypeCheckingFilter(output);
                    filter2.setRequiredType(finalType, expr.requiredCardinality, (RoleDiagnostic)expr.roleSupplier.get(), expr.getLocation());
                    TailCall tc = pushEval.processLeavingTail(filter2, context);
                    Expression.dispatchTailCall(tc);
                    try {
                        filter2.finalCheck();
                    }
                    catch (XPathException e) {
                        throw e.maybeWithLocation(expr.getLocation());
                    }
                    return null;
                };
            }
            PullEvaluator argEval = next.makeElaborator().elaborateForPull();
            return (output, context) -> {
                Item item;
                SequenceIterator iter = expr.checkCardinality(argEval.iterate(context), context);
                while ((item = iter.next()) != null) {
                    output.append(item);
                }
                return null;
            };
        }
    }
}

