/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OrderByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;

public class OrderByClausePush
extends TuplePush {
    private final TuplePush destination;
    private final OrderByClause orderByClause;
    private final TupleExpression tupleExpr;
    private final AtomicComparer[] comparers;
    private final XPathContext context;
    private int position = 0;
    private final ArrayList<ItemToBeSorted> tupleArray = new ArrayList(100);

    public OrderByClausePush(Outputter outputter, TuplePush destination, TupleExpression tupleExpr, OrderByClause orderBy, XPathContext context) {
        super(outputter);
        this.destination = destination;
        this.tupleExpr = tupleExpr;
        this.orderByClause = orderBy;
        this.context = context;
        AtomicComparer[] suppliedComparers = orderBy.getAtomicComparers();
        this.comparers = new AtomicComparer[suppliedComparers.length];
        for (int n = 0; n < this.comparers.length; ++n) {
            this.comparers[n] = suppliedComparers[n].provideContext(context);
        }
    }

    @Override
    public void processTuple(XPathContext context) throws XPathException {
        Tuple tuple = this.tupleExpr.evaluateItem(context);
        SortKeyDefinitionList sortKeyDefinitions = this.orderByClause.getSortKeyDefinitions();
        ItemToBeSorted itbs = new ItemToBeSorted(sortKeyDefinitions.size());
        itbs.value = tuple;
        for (int i2 = 0; i2 < sortKeyDefinitions.size(); ++i2) {
            itbs.sortKeyValues[i2] = this.orderByClause.evaluateSortKey(i2, context);
        }
        itbs.originalPosition = ++this.position;
        this.tupleArray.add(itbs);
    }

    @Override
    public void close() throws XPathException {
        try {
            this.tupleArray.sort((a, b) -> {
                try {
                    for (int i2 = 0; i2 < this.comparers.length; ++i2) {
                        int comp = this.comparers[i2].compareAtomicValues(a.sortKeyValues[i2], b.sortKeyValues[i2]);
                        if (comp == 0) continue;
                        return comp;
                    }
                }
                catch (NoDynamicContextException e) {
                    throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
                }
                return a.originalPosition - b.originalPosition;
            });
        }
        catch (ClassCastException e) {
            throw new XPathException("Non-comparable types found while sorting: " + e.getMessage(), "XPTY0004");
        }
        for (ItemToBeSorted itbs : this.tupleArray) {
            this.tupleExpr.setCurrentTuple(this.context, (Tuple)itbs.value);
            this.destination.processTuple(this.context);
        }
        this.destination.close();
    }
}

