/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public final class Bindery {
    private SlotManager slotManager;
    private GroundedValue[] globals;

    public Bindery(PackageData pack) {
        this.slotManager = pack.getGlobalSlotManager();
        this.allocateGlobals(this.slotManager);
    }

    private void allocateGlobals(SlotManager map) {
        int n = map.getNumberOfVariables() + 1;
        this.globals = new GroundedValue[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.globals[i2] = null;
        }
    }

    public void setGlobalVariable(GlobalVariable binding, GroundedValue value) {
        this.globals[binding.getBinderySlotNumber()] = value;
    }

    public synchronized GroundedValue saveGlobalVariableValue(GlobalVariable binding, GroundedValue value) {
        int slot = binding.getBinderySlotNumber();
        if (this.globals[slot] != null) {
            return this.globals[slot];
        }
        this.globals[slot] = value;
        return value;
    }

    public void setGlobalVariableValue(int slot, GroundedValue value) {
        this.globals[slot] = value;
    }

    public GroundedValue getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getBinderySlotNumber()];
    }

    public GroundedValue getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public GroundedValue[] getGlobalVariables() {
        return this.globals;
    }

    public static class FailureValue
    extends ObjectValue<XPathException> {
        public FailureValue(XPathException err) {
            super(err);
        }
    }
}

