/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.ConditionalInstruction;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.jiter.ConcatenatingIterable;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class Choose
extends Instruction
implements ConditionalInstruction {
    private final Operand[] conditionOps;
    private final Operand[] actionOps;
    private boolean _isInstruction;
    public static final OperandRole CHOICE_ACTION = new OperandRole(8, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public Choose(Expression[] conditions, Expression[] actions) {
        int i2;
        assert (conditions.length == actions.length);
        this.conditionOps = new Operand[conditions.length];
        for (i2 = 0; i2 < conditions.length; ++i2) {
            this.conditionOps[i2] = new Operand(this, conditions[i2], OperandRole.INSPECT);
        }
        this.actionOps = new Operand[actions.length];
        for (i2 = 0; i2 < actions.length; ++i2) {
            this.actionOps[i2] = new Operand(this, actions[i2], CHOICE_ACTION);
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, Literal.makeLiteral(BooleanValue.TRUE, condition)};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public void setInstruction(boolean inst) {
        this._isInstruction = inst;
    }

    @Override
    public boolean isInstruction() {
        return this._isInstruction;
    }

    public int size() {
        return this.conditionOps.length;
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).size() == 1;
    }

    public boolean isActionOperand(Expression child) {
        for (Operand actionOp : this.actionOps) {
            if (actionOp.getChildExpression() != child) continue;
            return true;
        }
        return false;
    }

    public Expression getCondition(int i2) {
        return this.conditionOps[i2].getChildExpression();
    }

    public void setCondition(int i2, Expression condition) {
        this.conditionOps[i2].setChildExpression(condition);
    }

    public Iterable<Operand> conditions() {
        return Arrays.asList(this.conditionOps);
    }

    public Operand getActionOperand(int i2) {
        return this.actionOps[i2];
    }

    public Expression getAction(int i2) {
        return this.actionOps[i2].getChildExpression();
    }

    public void setAction(int i2, Expression action) {
        this.actionOps[i2].setChildExpression(action);
    }

    public Iterable<Operand> actions() {
        return Arrays.asList(this.actionOps);
    }

    @Override
    public Iterable<Operand> operands() {
        return new ConcatenatingIterable<Operand>(Arrays.asList(this.conditionOps), Arrays.asList(this.actionOps));
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    public void atomizeActions() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, Atomizer.makeAtomizer(this.getAction(i2), null));
        }
    }

    @Override
    public int getInstructionNameCode() {
        return this.size() == 1 ? 162 : 143;
    }

    @Override
    public Expression simplify() throws XPathException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setCondition(i2, this.getCondition(i2).simplify());
            try {
                this.setAction(i2, this.getAction(i2).simplify());
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.setAction(i2, new ErrorExpression(new XmlProcessingException(err)));
            }
        }
        return this;
    }

    private Expression removeRedundantBranches(ExpressionVisitor visitor) {
        Expression result = this.removeRedundantBranches0(visitor);
        if (result != this) {
            ExpressionTool.copyLocationInfo(this, result);
        }
        return result;
    }

    private Expression removeRedundantBranches0(ExpressionVisitor visitor) {
        int i2;
        Expression[] actions;
        Expression[] conditions;
        boolean compress = false;
        for (int i3 = 0; i3 < this.size(); ++i3) {
            Expression condition = this.getCondition(i3);
            if (!(condition instanceof Literal)) continue;
            compress = true;
            break;
        }
        int count = this.size();
        if (compress) {
            conditions = new ArrayList(count);
            actions = new ArrayList(count);
            for (i2 = 0; i2 < count; ++i2) {
                Expression condition = this.getCondition(i2);
                if (!Literal.hasEffectiveBooleanValue(condition, false)) {
                    conditions.add(condition);
                    actions.add(this.getAction(i2));
                }
                if (Literal.hasEffectiveBooleanValue(condition, true)) break;
            }
            if (conditions.isEmpty()) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (conditions.size() == 1 && Literal.hasEffectiveBooleanValue((Expression)conditions.get(0), true)) {
                return (Expression)actions.get(0);
            }
            if (conditions.size() != count) {
                Expression[] c = conditions.toArray(new Expression[0]);
                Expression[] a = actions.toArray(new Expression[0]);
                Choose result = new Choose(c, a);
                result.setRetainedStaticContext(this.getRetainedStaticContext());
                return result;
            }
        }
        if (this.size() == 1 && Literal.hasEffectiveBooleanValue(this.getCondition(0), true)) {
            return this.getAction(0);
        }
        if (Literal.isEmptySequence(this.getAction(this.size() - 1))) {
            if (this.size() == 1) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            conditions = new Expression[count - 1];
            actions = new Expression[count - 1];
            for (i2 = 0; i2 < count - 1; ++i2) {
                conditions[i2] = this.getCondition(i2);
                actions[i2] = this.getAction(i2);
            }
            return new Choose(conditions, actions);
        }
        if (Literal.hasEffectiveBooleanValue(this.getCondition(count - 1), true) && this.getAction(count - 1) instanceof Choose) {
            int i4;
            Choose choose2 = (Choose)this.getAction(count - 1);
            int newLen = count + choose2.size() - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            for (i4 = 0; i4 < count - 1; ++i4) {
                c2[i4] = this.getCondition(i4);
                a2[i4] = this.getAction(i4);
            }
            for (i4 = 0; i4 < choose2.size(); ++i4) {
                c2[i4 + count - 1] = choose2.getCondition(i4);
                a2[i4 + count - 1] = choose2.getAction(i4);
            }
            return new Choose(c2, a2);
        }
        if (count == 2 && Literal.isConstantBoolean(this.getAction(0), true) && Literal.isConstantBoolean(this.getAction(1), false) && Literal.hasEffectiveBooleanValue(this.getCondition(1), true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.getCondition(0).getItemType(), BuiltInAtomicType.BOOLEAN) && this.getCondition(0).getCardinality() == 16384) {
                return this.getCondition(0);
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getCondition(0));
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Optimizer opt;
        int i2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        for (i2 = 0; i2 < this.size(); ++i2) {
            this.conditionOps[i2].typeCheck(visitor, contextInfo);
            XPathException err = TypeChecker.ebvError(this.getCondition(i2), th);
            if (err == null) continue;
            throw err.withLocation(this.getCondition(i2).getLocation()).maybeWithFailingExpression(this.getCondition(i2));
        }
        for (i2 = 0; i2 < this.size(); ++i2) {
            if (Literal.hasEffectiveBooleanValue(this.getCondition(i2), false)) continue;
            try {
                this.actionOps[i2].typeCheck(visitor, contextInfo);
            }
            catch (XPathException err) {
                XPathException e2 = err.maybeWithLocation(this.getLocation()).maybeWithFailingExpression(this.getAction(i2));
                if (e2.isStaticError()) {
                    throw e2;
                }
                if (e2.isTypeError()) {
                    if (Literal.isEmptySequence(this.getAction(i2)) || Literal.hasEffectiveBooleanValue(this.getCondition(i2), false)) {
                        this.setAction(i2, new ErrorExpression(new XmlProcessingException(e2)));
                    }
                    throw e2;
                }
                this.setAction(i2, new ErrorExpression(new XmlProcessingException(e2)));
            }
            if (Literal.hasEffectiveBooleanValue(this.getCondition(i2), true)) break;
        }
        if ((opt = visitor.obtainOptimizer()).isOptionSet(32768)) {
            Expression reduced = this.removeRedundantBranches(visitor);
            if (reduced != this) {
                return reduced.typeCheck(visitor, contextInfo);
            }
            return reduced;
        }
        return this;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, Supplier<RoleDiagnostic> roleSupplier, ExpressionVisitor visitor) throws XPathException {
        int count = this.size();
        TypeChecker tc = this.getConfiguration().getTypeChecker(backwardsCompatible);
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                this.setAction(i2, tc.staticTypeCheck(this.getAction(i2), req, roleSupplier, visitor));
                continue;
            }
            catch (XPathException err) {
                if (err.isStaticError()) {
                    throw err;
                }
                ErrorExpression ee = new ErrorExpression(new XmlProcessingException(err));
                ExpressionTool.copyLocationInfo(this.getAction(i2), ee);
                this.setAction(i2, ee);
            }
        }
        if (!Literal.hasEffectiveBooleanValue(this.getCondition(count - 1), true) && !Cardinality.allowsZero(req.getCardinality())) {
            Expression[] c = new Expression[count + 1];
            Expression[] a = new Expression[count + 1];
            for (int i3 = 0; i3 < count; ++i3) {
                c[i3] = this.getCondition(i3);
                a[i3] = this.getAction(i3);
            }
            c[count] = Literal.makeLiteral(BooleanValue.TRUE, this);
            String cond = count == 1 ? "The condition is not" : "None of the conditions is";
            RoleDiagnostic role = roleSupplier.get();
            String message = "Conditional expression: " + cond + " satisfied, so an empty sequence is returned, but this is not allowed as the " + role.getMessage();
            ErrorExpression errExp = new ErrorExpression(message, role.getErrorCode(), true);
            ExpressionTool.copyLocationInfo(this, errExp);
            a[count] = errExp;
            return new Choose(c, a);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int i2;
        int count = this.size();
        for (i2 = 0; i2 < count; ++i2) {
            boolean b;
            this.conditionOps[i2].optimize(visitor, contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.getCondition(i2), visitor, contextItemType);
            if (ebv != null && ebv != this.getCondition(i2)) {
                this.setCondition(i2, ebv);
            }
            if (!(this.getCondition(i2) instanceof Literal) || ((Literal)this.getCondition(i2)).getGroundedValue() instanceof BooleanValue) continue;
            try {
                b = ((Literal)this.getCondition(i2)).getGroundedValue().effectiveBooleanValue();
            }
            catch (XPathException err) {
                throw err.withLocation(this.getLocation());
            }
            this.setCondition(i2, Literal.makeLiteral(BooleanValue.get(b), this));
        }
        for (i2 = 0; i2 < count; ++i2) {
            if (Literal.hasEffectiveBooleanValue(this.getCondition(i2), false)) continue;
            try {
                this.actionOps[i2].optimize(visitor, contextItemType);
            }
            catch (XPathException err) {
                if (err.isTypeError() && !visitor.isInliningFunctions()) {
                    throw err;
                }
                ErrorExpression ee = new ErrorExpression(new XmlProcessingException(err));
                ExpressionTool.copyLocationInfo(this.actionOps[i2].getChildExpression(), ee);
                this.setAction(i2, ee);
            }
            if (this.getAction(i2) instanceof ErrorExpression && ((ErrorExpression)this.getAction(i2)).isTypeError() && !Literal.isConstantBoolean(this.getCondition(i2), false) && !Literal.isConstantBoolean(this.getCondition(i2), true)) {
                visitor.issueWarning("Branch " + (i2 + 1) + " of conditional will fail with a type error if executed. " + ((ErrorExpression)this.getAction(i2)).getMessage(), "SXWN9027", this.getAction(i2).getLocation());
            }
            if (Literal.hasEffectiveBooleanValue(this.getCondition(i2), true)) break;
        }
        if (count == 0) {
            return Literal.makeEmptySequence();
        }
        Optimizer opt = visitor.obtainOptimizer();
        if (opt.isOptionSet(32768)) {
            Expression e = this.removeRedundantBranches(visitor);
            if (e instanceof Choose) {
                return visitor.obtainOptimizer().trySwitch((Choose)e, visitor);
            }
            return e;
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        int count = this.size();
        Expression[] c2 = new Expression[count];
        Expression[] a2 = new Expression[count];
        for (int c = 0; c < count; ++c) {
            c2[c] = this.getCondition(c).copy(rebindings);
            a2[c] = this.getAction(c).copy(rebindings);
        }
        Choose ch2 = new Choose(c2, a2);
        ExpressionTool.copyLocationInfo(this, ch2);
        ch2.setInstruction(this.isInstruction());
        return ch2;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        for (Operand o : this.conditions()) {
            Expression condition = o.getChildExpression();
            condition.checkForUpdatingSubexpressions();
            if (!condition.isUpdatingExpression()) continue;
            XPathException err = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            err.setLocator(condition.getLocation());
            throw err;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (Operand o : this.actions()) {
            Expression act = o.getChildExpression();
            act.checkForUpdatingSubexpressions();
            if (ExpressionTool.isNotAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err.setLocator(act.getLocation());
                    throw err;
                }
                nonUpdating = true;
            }
            if (!act.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                err.setLocator(act.getLocation());
                throw err;
            }
            updating = true;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        for (Operand o : this.actions()) {
            if (!o.getChildExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        for (Operand action : this.actions()) {
            if (action.getChildExpression().isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int m = 14;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result = 0;
        for (Operand action : this.actions()) {
            result = Math.max(result, action.getChildExpression().markTailFunctionCalls(qName, arity));
        }
        return result;
    }

    @Override
    public ItemType getItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getAction(0).getItemType();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            type = Type.getCommonSuperType(type, this.getAction(i2).getItemType(), th);
        }
        return type;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        if (this.isInstruction()) {
            return super.getStaticUType(contextItemType);
        }
        UType type = this.getAction(0).getStaticUType(contextItemType);
        for (int i2 = 1; i2 < this.size(); ++i2) {
            type = type.union(this.getAction(i2).getStaticUType(contextItemType));
        }
        return type;
    }

    @Override
    protected int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            card = Cardinality.union(card, this.getAction(i2).getCardinality());
            if (!Literal.hasEffectiveBooleanValue(this.getCondition(i2), true)) continue;
            includesTrue = true;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    @Override
    protected int computeSpecialProperties() {
        int props = this.getAction(0).getSpecialProperties();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            props &= this.getAction(i2).getSpecialProperties();
        }
        return props;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        for (Operand action : this.actions()) {
            int props = action.getChildExpression().getSpecialProperties();
            if ((props & 0x800000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, this.getAction(i2).unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        for (Operand action : this.actions()) {
            action.getChildExpression().checkPermittedContents(parentType, whole);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Operand condition : this.conditions()) {
            condition.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Operand action : this.actions()) {
            PathMap.PathMapNodeSet temp = action.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
            result.addNodeSet(temp);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("if (");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sb.append(this.getCondition(i2).toString());
            sb.append(") then (");
            sb.append(this.getAction(i2).toString());
            if (i2 == this.size() - 1) {
                sb.append(")");
                continue;
            }
            sb.append(") else if (");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "if(" + this.getCondition(0).toShortString() + ") then ... else ...";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("choose", this);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getCondition(i2).export(out);
            this.getAction(i2).export(out);
        }
        out.endElement();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public String getExpressionName() {
        return "choose";
    }

    @Override
    public String getStreamerName() {
        return "Choose";
    }

    @Override
    public Elaborator getElaborator() {
        return new ChooseExprElaborator();
    }

    public BooleanEvaluator[] getConditionEvaluators() {
        return ((ChooseExprElaborator)this.makeElaborator()).makeConditionEvaluators(this);
    }

    private static class EagerChooseEvaluator
    implements SequenceEvaluator {
        private final BooleanEvaluator[] conditions;
        private final SequenceEvaluator[] actions;
        private final int count;

        public EagerChooseEvaluator(BooleanEvaluator[] conditions, SequenceEvaluator[] actions) {
            this.conditions = conditions;
            this.actions = actions;
            this.count = conditions.length;
        }

        @Override
        public Sequence evaluate(XPathContext context) throws XPathException {
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (!this.conditions[i2].eval(context)) continue;
                return this.actions[i2].evaluate(context);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class ChooseExprElaborator
    extends PullElaborator {
        private BooleanEvaluator[] conditions;

        public BooleanEvaluator[] getConditionEvaluators() {
            return this.conditions;
        }

        public synchronized BooleanEvaluator[] makeConditionEvaluators(Choose expr) {
            if (this.conditions == null) {
                this.conditions = new BooleanEvaluator[expr.size()];
                for (int i2 = 0; i2 < expr.size(); ++i2) {
                    this.conditions[i2] = expr.getCondition(i2).makeElaborator().elaborateForBoolean();
                }
            }
            return this.conditions;
        }

        @Override
        public SequenceEvaluator eagerly() {
            Choose expr = (Choose)this.getExpression();
            int count = expr.size();
            this.makeConditionEvaluators(expr);
            SequenceEvaluator[] actions = new SequenceEvaluator[count];
            for (int i2 = 0; i2 < count; ++i2) {
                actions[i2] = expr.getAction(i2).makeElaborator().eagerly();
            }
            return new EagerChooseEvaluator(this.conditions, actions);
        }

        @Override
        public PullEvaluator elaborateForPull() {
            Choose expr = (Choose)this.getExpression();
            int count = expr.size();
            PullEvaluator[] actions = new PullEvaluator[count];
            this.makeConditionEvaluators(expr);
            for (int i2 = 0; i2 < count; ++i2) {
                actions[i2] = expr.getAction(i2).makeElaborator().elaborateForPull();
            }
            switch (count) {
                case 1: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].iterate(context);
                        }
                        return EmptyIterator.getInstance();
                    };
                }
                case 2: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].iterate(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].iterate(context);
                        }
                        return EmptyIterator.getInstance();
                    };
                }
                case 3: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].iterate(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].iterate(context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].iterate(context);
                        }
                        return EmptyIterator.getInstance();
                    };
                }
                case 4: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].iterate(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].iterate(context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].iterate(context);
                        }
                        if (this.conditions[3].eval(context)) {
                            return actions[3].iterate(context);
                        }
                        return EmptyIterator.getInstance();
                    };
                }
            }
            return context -> {
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!this.conditions[i2].eval(context)) continue;
                    return actions[i2].iterate(context);
                }
                return EmptyIterator.getInstance();
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            Choose expr = (Choose)this.getExpression();
            int count = expr.size();
            ItemEvaluator[] actions = new ItemEvaluator[count];
            this.makeConditionEvaluators(expr);
            for (int i2 = 0; i2 < count; ++i2) {
                actions[i2] = expr.getAction(i2).makeElaborator().elaborateForItem();
            }
            switch (count) {
                case 1: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].eval(context);
                        }
                        return null;
                    };
                }
                case 2: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].eval(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].eval(context);
                        }
                        return null;
                    };
                }
                case 3: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].eval(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].eval(context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].eval(context);
                        }
                        return null;
                    };
                }
                case 4: {
                    return context -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].eval(context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].eval(context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].eval(context);
                        }
                        if (this.conditions[3].eval(context)) {
                            return actions[3].eval(context);
                        }
                        return null;
                    };
                }
            }
            return context -> {
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!this.conditions[i2].eval(context)) continue;
                    return actions[i2].eval(context);
                }
                return null;
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            Choose expr = (Choose)this.getExpression();
            int count = expr.size();
            this.makeConditionEvaluators(expr);
            PushEvaluator[] actions = new PushEvaluator[count];
            for (int i2 = 0; i2 < count; ++i2) {
                actions[i2] = expr.getAction(i2).makeElaborator().elaborateForPush();
            }
            switch (count) {
                case 1: {
                    return (output, context) -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].processLeavingTail(output, context);
                        }
                        return null;
                    };
                }
                case 2: {
                    return (output, context) -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].processLeavingTail(output, context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].processLeavingTail(output, context);
                        }
                        return null;
                    };
                }
                case 3: {
                    return (output, context) -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].processLeavingTail(output, context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].processLeavingTail(output, context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].processLeavingTail(output, context);
                        }
                        return null;
                    };
                }
                case 4: {
                    return (output, context) -> {
                        if (this.conditions[0].eval(context)) {
                            return actions[0].processLeavingTail(output, context);
                        }
                        if (this.conditions[1].eval(context)) {
                            return actions[1].processLeavingTail(output, context);
                        }
                        if (this.conditions[2].eval(context)) {
                            return actions[2].processLeavingTail(output, context);
                        }
                        if (this.conditions[3].eval(context)) {
                            return actions[3].processLeavingTail(output, context);
                        }
                        return null;
                    };
                }
            }
            return (output, context) -> {
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!this.conditions[i2].eval(context)) continue;
                    return actions[i2].processLeavingTail(output, context);
                }
                return null;
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            Choose expr = (Choose)this.getExpression();
            int count = expr.size();
            this.makeConditionEvaluators(expr);
            UpdateEvaluator[] actions = new UpdateEvaluator[count];
            for (int i2 = 0; i2 < count; ++i2) {
                actions[i2] = expr.getAction(i2).makeElaborator().elaborateForUpdate();
            }
            return (context, updates) -> {
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!this.conditions[i2].eval(context)) continue;
                    actions[i2].registerUpdates(context, updates);
                    break;
                }
            };
        }
    }
}

