/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CollationMatchKey;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;

public class RuleBasedSubstringMatcher
extends SimpleCollation
implements SubstringMatcher {
    public RuleBasedSubstringMatcher(String uri, RuleBasedCollator collator) {
        super(uri, collator);
    }

    private RuleBasedCollator getRuleBasedCollator() {
        return (RuleBasedCollator)this.getComparator();
    }

    @Override
    public boolean contains(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationContains(iter1, iter2, null, false);
    }

    @Override
    public boolean endsWith(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationContains(iter1, iter2, null, true);
    }

    @Override
    public boolean startsWith(UnicodeString s1, UnicodeString s2) {
        RuleBasedCollator collator = this.getRuleBasedCollator();
        CollationElementIterator iter1 = collator.getCollationElementIterator(s1.toString());
        CollationElementIterator iter2 = collator.getCollationElementIterator(s2.toString());
        return this.collationStartsWith(iter1, iter2);
    }

    @Override
    public UnicodeString substringAfter(UnicodeString s1, UnicodeString s2) {
        int[] ia;
        CollationElementIterator iter2;
        RuleBasedCollator collator = this.getRuleBasedCollator();
        String g1 = s1.toString();
        String g2 = s2.toString();
        CollationElementIterator iter1 = collator.getCollationElementIterator(g1);
        boolean ba = this.collationContains(iter1, iter2 = collator.getCollationElementIterator(g2), ia = new int[2], false);
        if (ba) {
            return s1.substring(ia[1]);
        }
        return EmptyUnicodeString.getInstance();
    }

    @Override
    public UnicodeString substringBefore(UnicodeString s1, UnicodeString s2) {
        int[] ib;
        CollationElementIterator iter2;
        RuleBasedCollator collator = this.getRuleBasedCollator();
        String g1 = s1.toString();
        String g2 = s2.toString();
        CollationElementIterator iter1 = collator.getCollationElementIterator(g1);
        boolean bb = this.collationContains(iter1, iter2 = collator.getCollationElementIterator(g2), ib = new int[2], false);
        if (bb) {
            return s1.prefix(ib[0]);
        }
        return EmptyUnicodeString.getInstance();
    }

    private boolean collationStartsWith(CollationElementIterator s0, CollationElementIterator s1) {
        while (true) {
            int e0;
            int e1;
            if ((e1 = s1.next()) == 0) {
                continue;
            }
            if (e1 == -1) {
                return true;
            }
            while ((e0 = s0.next()) == 0) {
            }
            if (e0 != e1) break;
        }
        return false;
    }

    private boolean collationContains(CollationElementIterator s0, CollationElementIterator s1, int[] offsets, boolean matchAtEnd) {
        int e1;
        while ((e1 = s1.next()) == 0) {
        }
        if (e1 == -1) {
            return true;
        }
        int e0 = -1;
        while (true) {
            if (e0 != e1) {
                while ((e0 = s0.next()) == 0) {
                }
                if (e0 != -1) continue;
                return false;
            }
            int start = s0.getOffset();
            if (this.collationStartsWith(s0, s1)) {
                if (matchAtEnd) {
                    while ((e0 = s0.next()) == 0) {
                    }
                    if (e0 == -1) {
                        return true;
                    }
                } else {
                    if (offsets != null) {
                        offsets[0] = start - 1;
                        offsets[1] = s0.getOffset();
                    }
                    return true;
                }
            }
            s0.setOffset(start);
            if (s0.getOffset() != start) {
                s0.next();
            }
            s1.reset();
            e0 = -1;
            while ((e1 = s1.next()) == 0) {
            }
        }
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s) {
        return new CollationMatchKey(this.getRuleBasedCollator().getCollationKey(s.toString()));
    }

    public static void main(String[] args) throws Exception {
        String rules = " ='-'='*'< a < b < c < d < e < f < g < h < i < j < k < l < m < n < o < p < q < r < s < t < u < v < w < x < y < z";
        RuleBasedCollator collator = new RuleBasedCollator(rules);
        for (int i2 = 0; i2 < args.length; ++i2) {
            int e;
            System.err.println(args[i2]);
            StringBuilder sb = new StringBuilder(256);
            CollationElementIterator iter = collator.getCollationElementIterator(args[i2]);
            while ((e = iter.next()) != -1) {
                sb.append(e + " ");
            }
            System.err.println(sb.toString());
        }
    }
}

