/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.functions.hof.CurriedFunction;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RegexGroup
extends ContextAccessorFunction {
    @Override
    public FunctionItem bindContext(XPathContext context) throws XPathException {
        CallableFunction alwaysEmptyFunction = new CallableFunction(1, (Callable)new AlwaysEmpty(), (FunctionItemType)new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_INTEGER}, SequenceType.SINGLE_STRING));
        if (this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() < 40) {
            return alwaysEmptyFunction;
        }
        RegexIterator ri = context.getCurrentRegexIterator();
        if (ri == null) {
            throw new XPathException("There is no current group", "XTDE1061");
        }
        int groups = ri.getNumberOfGroups();
        MapItem map = new HashTrieMap();
        for (int i2 = 0; i2 <= groups; ++i2) {
            map = ((MapItem)map).addEntry(Int64Value.makeIntegerValue(i2), new StringValue(ri.getRegexGroup(i2)));
        }
        StructuredQName mapGetName = new StructuredQName("map", NamespaceUri.MAP_FUNCTIONS, "get");
        MapFunctionSet lib = MapFunctionSet.getInstance(40);
        SymbolicName.F symbolicName = new SymbolicName.F(mapGetName, 3);
        FunctionItem mapGet3 = lib.getFunctionItem(symbolicName, new IndependentContext(context.getConfiguration()));
        return new CurriedFunction(mapGet3, new Sequence[]{map, null, alwaysEmptyFunction});
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        RegexIterator iter = context.getCurrentRegexIterator();
        if (iter == null) {
            return StringValue.EMPTY_STRING;
        }
        NumericValue gp0 = (NumericValue)arguments[0].head();
        UnicodeString s = iter.getRegexGroup((int)gp0.longValue());
        return StringValue.makeUStringValue(s);
    }

    private static class AlwaysEmpty
    implements Callable {
        private AlwaysEmpty() {
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return StringValue.EMPTY_STRING;
        }
    }
}

