/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.FunctionItemType;

public class UnboundFunctionLibrary
implements FunctionLibrary {
    private List<UserFunctionResolvable> unboundFunctionReferences = new ArrayList<UserFunctionResolvable>(20);
    private List<StaticContext> correspondingStaticContext = new ArrayList<StaticContext>(20);
    private final List<List<String>> correspondingReasons = new ArrayList<List<String>>();
    private boolean resolving = false;

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] arguments, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        if (this.resolving) {
            return null;
        }
        if (!reasons.isEmpty() && reasons.get(0).startsWith("Cannot call the private XQuery function")) {
            return null;
        }
        UnboundFunctionCallDetails details = new UnboundFunctionCallDetails(functionName, arguments, keywords, env);
        UserFunctionCall ufc = new UserFunctionCall(details);
        this.unboundFunctionReferences.add(ufc);
        this.correspondingStaticContext.add(env);
        this.correspondingReasons.add(reasons);
        return ufc;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) {
        if (this.resolving) {
            return null;
        }
        XQueryFunctionLibrary.UnresolvedCallable uc = new XQueryFunctionLibrary.UnresolvedCallable(functionName);
        this.unboundFunctionReferences.add(uc);
        this.correspondingStaticContext.add(null);
        this.correspondingReasons.add(new ArrayList());
        CallableFunction fi = new CallableFunction(functionName, (Callable)uc, (FunctionItemType)AnyFunctionType.getInstance());
        return fi;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return false;
    }

    public void bindUnboundFunctionReferences(XQueryFunctionBinder lib, Configuration config) throws XPathException {
        this.resolving = true;
        for (int i2 = 0; i2 < this.unboundFunctionReferences.size(); ++i2) {
            int arity;
            UserFunctionResolvable ref = this.unboundFunctionReferences.get(i2);
            if (ref instanceof UserFunctionCall) {
                String supplementary;
                UserFunctionCall ufc = (UserFunctionCall)ref;
                QueryModule importingModule = (QueryModule)this.correspondingStaticContext.get(i2);
                if (importingModule == null) continue;
                this.correspondingStaticContext.set(i2, null);
                UnboundFunctionCallDetails details = ufc.getUnboundCallDetails();
                boolean success = lib.bindUnboundFunctionCall(ufc, new ArrayList<String>());
                if (success) continue;
                StringBuilder sb = new StringBuilder("Cannot find a " + details.arguments.length + "-argument function named " + details.functionName.getComponentName().getEQName() + "()");
                List<String> reasons = this.correspondingReasons.get(i2);
                for (String reason : reasons) {
                    sb.append(". ").append(reason);
                }
                if (reasons.isEmpty() && (supplementary = XPathParser.getMissingFunctionExplanation(details.functionName.getComponentName(), config)) != null) {
                    sb.append(". ").append(supplementary);
                }
                XPathException err = new XPathException(sb.toString(), "XPST0017", ufc.getLocation());
                err.setIsStaticError(true);
                throw err;
            }
            if (!(ref instanceof XQueryFunctionLibrary.UnresolvedCallable)) continue;
            XQueryFunctionLibrary.UnresolvedCallable uc = (XQueryFunctionLibrary.UnresolvedCallable)ref;
            StructuredQName q = uc.getFunctionName();
            XQueryFunction fd = lib.getDeclaration(q, arity = uc.getArity());
            if (fd != null) {
                fd.registerReference(uc);
                continue;
            }
            String msg = "Cannot find a " + arity + "-argument function named " + q.getEQName() + "()";
            if (!config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
                msg = msg + ". Note: external function calls have been disabled";
            }
            throw new XPathException(msg).withErrorCode("XPST0017").asStaticError();
        }
    }

    @Override
    public FunctionLibrary copy() {
        UnboundFunctionLibrary qfl = new UnboundFunctionLibrary();
        qfl.unboundFunctionReferences = new ArrayList<UserFunctionResolvable>(this.unboundFunctionReferences);
        qfl.correspondingStaticContext = new ArrayList<StaticContext>(this.correspondingStaticContext);
        qfl.resolving = this.resolving;
        return qfl;
    }

    public static class UnboundFunctionCallDetails {
        public SymbolicName.F functionName;
        public Expression[] arguments;
        public Map<StructuredQName, Integer> keywords;
        public StaticContext env;

        public UnboundFunctionCallDetails(SymbolicName.F functionName, Expression[] arguments, Map<StructuredQName, Integer> keywords, StaticContext env) {
            this.functionName = functionName;
            this.arguments = arguments;
            this.keywords = keywords;
            this.env = env;
        }
    }
}

