/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.History;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.RegexPrecondition;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntPredicateProxy;

public class REMatcher {
    static final int MAX_PAREN = 16;
    REProgram program;
    UnicodeString search;
    History history = new History();
    int maxParen = 16;
    State _captureState = new State();
    int[] startBackref;
    int[] endBackref;
    Operation operation;
    boolean anchoredMatch;

    public REMatcher(REProgram program) {
        this.setProgram(program);
    }

    public void setProgram(REProgram program) {
        this.program = program;
        if (program != null && program.maxParens != -1) {
            this.operation = program.operation;
            this.maxParen = program.maxParens;
        } else {
            this.maxParen = 16;
        }
    }

    public REProgram getProgram() {
        return this.program;
    }

    public int getParenCount() {
        return this._captureState.parenCount;
    }

    public UnicodeString getParen(int which) {
        int start;
        if (which < this._captureState.parenCount && (start = this.getParenStart(which)) >= 0) {
            return this.search.substring(start, this.getParenEnd(which));
        }
        return null;
    }

    public final int getParenStart(int which) {
        if (which < this._captureState.startn.length) {
            return this._captureState.startn[which];
        }
        return -1;
    }

    public final int getParenEnd(int which) {
        if (which < this._captureState.endn.length) {
            return this._captureState.endn[which];
        }
        return -1;
    }

    protected final void setParenStart(int which, int i2) {
        while (which > this._captureState.startn.length - 1) {
            int[] s2 = new int[this._captureState.startn.length * 2];
            System.arraycopy(this._captureState.startn, 0, s2, 0, this._captureState.startn.length);
            Arrays.fill(s2, this._captureState.startn.length, s2.length, -1);
            this._captureState.startn = s2;
        }
        this._captureState.startn[which] = i2;
    }

    protected final void setParenEnd(int which, int i2) {
        while (which > this._captureState.endn.length - 1) {
            int[] e2 = new int[this._captureState.endn.length * 2];
            System.arraycopy(this._captureState.endn, 0, e2, 0, this._captureState.endn.length);
            Arrays.fill(e2, this._captureState.endn.length, e2.length, -1);
            this._captureState.endn = e2;
        }
        this._captureState.endn[which] = i2;
    }

    protected void clearCapturedGroupsBeyond(int pos) {
        int i2;
        for (i2 = 0; i2 < this._captureState.startn.length; ++i2) {
            if (this._captureState.startn[i2] < pos) continue;
            this._captureState.endn[i2] = this._captureState.startn[i2];
        }
        if (this.startBackref != null) {
            for (i2 = 0; i2 < this.startBackref.length; ++i2) {
                if (this.startBackref[i2] < pos) continue;
                this.endBackref[i2] = this.startBackref[i2];
            }
        }
    }

    protected boolean matchAt(int i2, boolean anchored) {
        IntIterator iter;
        this._captureState.parenCount = 1;
        this.anchoredMatch = anchored;
        this.setParenStart(0, i2);
        if ((this.program.optimizationFlags & 1) != 0) {
            this.startBackref = new int[this.maxParen];
            this.endBackref = new int[this.maxParen];
        }
        if ((iter = this.operation.iterateMatches(this, i2)).hasNext()) {
            int idx = iter.next();
            this.setParenEnd(0, idx);
            return true;
        }
        this._captureState.parenCount = 0;
        return false;
    }

    public boolean isAnchoredMatch(UnicodeString search) {
        this.search = search;
        return this.matchAt(0, true);
    }

    public boolean match(UnicodeString search, int i2) {
        Objects.requireNonNull(search);
        this.search = search.tidy();
        this._captureState = new State();
        if ((this.program.optimizationFlags & 2) == 2) {
            if (!this.program.flags.isMultiLine()) {
                return i2 == 0 && this.checkPreconditions(i2) && this.matchAt(i2, false);
            }
            int nl = i2;
            if (this.matchAt(nl, false)) {
                return true;
            }
            do {
                if ((long)(nl = (int)search.indexOf(10, (long)nl) + 1) < search.length() && nl > 0) continue;
                return false;
            } while (!this.matchAt(nl, false));
            return true;
        }
        int actualLength = search.length32() - i2;
        if (actualLength < this.program.minimumLength) {
            return false;
        }
        if (this.program.prefix == null) {
            if (this.program.initialCharClass != null) {
                IntPredicateProxy pred = this.program.initialCharClass;
                while (i2 < search.length32()) {
                    if (pred.test(search.codePointAt(i2)) && this.matchAt(i2, false)) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
            if (!this.checkPreconditions(i2)) {
                return false;
            }
            while (i2 - 1 < search.length32()) {
                if (this.matchAt(i2, false)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        UnicodeString prefix = this.program.prefix;
        int prefixLength = prefix.length32();
        boolean ignoreCase = this.program.flags.isCaseIndependent();
        while ((long)(i2 + prefixLength - 1) < search.length()) {
            int k;
            int j;
            boolean prefixOK = true;
            if (ignoreCase) {
                j = i2;
                for (k = 0; k < prefixLength; ++k) {
                    if (!this.equalCaseBlind(search.codePointAt(j), prefix.codePointAt(k))) {
                        prefixOK = false;
                        break;
                    }
                    ++j;
                }
            } else {
                j = i2;
                for (k = 0; k < prefixLength; ++k) {
                    if (search.codePointAt(j) != prefix.codePointAt(k)) {
                        prefixOK = false;
                        break;
                    }
                    ++j;
                }
            }
            if (prefixOK && this.matchAt(i2, false)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean checkPreconditions(int start) {
        for (RegexPrecondition condition : this.program.preconditions) {
            if (condition.fixedPosition != -1) {
                boolean match = condition.operation.iterateMatches(this, condition.fixedPosition).hasNext();
                if (match) continue;
                return false;
            }
            int i2 = start;
            if (i2 < condition.minPosition) {
                i2 = condition.minPosition;
            }
            boolean found = false;
            while ((long)i2 < this.search.length()) {
                if ((condition.fixedPosition == -1 || condition.fixedPosition == i2) && condition.operation.iterateMatches(this, i2).hasNext()) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean match(String search) {
        return this.match(StringView.of(search).tidy(), 0);
    }

    public List<UnicodeString> split(UnicodeString s) {
        ArrayList<UnicodeString> v = new ArrayList<UnicodeString>();
        int pos = 0;
        int len = s.length32();
        while (pos < len && this.match(s, pos)) {
            int start = this.getParenStart(0);
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                v.add(s.substring(pos, start + 1));
            } else {
                v.add(s.substring(pos, start));
            }
            pos = ++newpos;
        }
        UnicodeString remainder = s.substring(pos, len);
        v.add(remainder);
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UnicodeString replace(UnicodeString in, UnicodeString replacement) {
        UnicodeString result = EmptyUnicodeString.getInstance();
        int pos = 0;
        int len = in.length32();
        boolean firstMatch = true;
        boolean simpleReplacement = false;
        while (pos < len && this.match(in, pos)) {
            int newpos;
            result = result.concat(in.substring(pos, this.getParenStart(0)));
            if (firstMatch) {
                simpleReplacement = this.program.flags.isLiteral();
                firstMatch = false;
            }
            if (!simpleReplacement) {
                int maxCapture = this.program.maxParens - 1;
                simpleReplacement = true;
                int i2 = 0;
                while ((long)i2 < replacement.length()) {
                    int index;
                    int ch = replacement.codePointAt(i2);
                    if (ch == 92) {
                        simpleReplacement = false;
                        if ((ch = replacement.codePointAt(index = ++i2)) != 92 && ch != 36) throw new RESyntaxException("Invalid escape '" + ch + "' in replacement string");
                        result = result.concat(BMPString.of("" + (char)ch));
                    } else if (ch == 36) {
                        UnicodeString captured;
                        simpleReplacement = false;
                        if ((ch = replacement.codePointAt(index = ++i2)) < 48 || ch > 57) {
                            throw new RESyntaxException("$ in replacement string must be followed by a digit");
                        }
                        int n = ch - 48;
                        if (maxCapture <= 9) {
                            if (maxCapture >= n && (captured = this.getParen(n)) != null) {
                                result = result.concat(captured);
                            }
                        } else {
                            while ((long)(++i2) < replacement.length()) {
                                ch = replacement.codePointAt(i2);
                                if (ch >= 48 && ch <= 57) {
                                    int m = n * 10 + (ch - 48);
                                    if (m > maxCapture) {
                                        --i2;
                                        break;
                                    }
                                    n = m;
                                    continue;
                                }
                                --i2;
                                break;
                            }
                            if ((captured = this.getParen(n)) != null) {
                                result = result.concat(captured);
                            }
                        }
                    } else {
                        result = result.concat(new UnicodeChar(ch));
                    }
                    ++i2;
                }
            } else {
                result = result.concat(replacement);
            }
            if ((newpos = this.getParenEnd(0)) == pos) {
                // empty if block
            }
            pos = ++newpos;
        }
        if (firstMatch) {
            return in;
        }
        result = result.concat(in.substring(pos, len));
        return result.economize();
    }

    public UnicodeString replaceWith(UnicodeString in, BiFunction<UnicodeString, UnicodeString[], UnicodeString> replacer) {
        UnicodeBuilder sb = new UnicodeBuilder();
        int pos = 0;
        int len = in.length32();
        while (pos < len && this.match(in, pos)) {
            for (long i2 = (long)pos; i2 < (long)this.getParenStart(0); ++i2) {
                sb.append(in.codePointAt(i2));
            }
            UnicodeString matchingSubstring = in.substring(this.getParenStart(0), this.getParenEnd(0));
            int nrOfGroups = this.program.maxParens - 1;
            UnicodeString[] groups = new UnicodeString[nrOfGroups];
            for (int i3 = 0; i3 < nrOfGroups; ++i3) {
                groups[i3] = this.getParen(i3 + 1);
                if (groups[i3] != null) continue;
                groups[i3] = EmptyUnicodeString.getInstance();
            }
            UnicodeString replacement = replacer.apply(matchingSubstring, groups);
            IntIterator iter = replacement.codePoints();
            while (iter.hasNext()) {
                sb.append(iter.next());
            }
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                // empty if block
            }
            pos = ++newpos;
        }
        for (int i4 = pos; i4 < len; ++i4) {
            sb.append(in.codePointAt(i4));
        }
        return sb.toUnicodeString();
    }

    boolean isNewline(int i2) {
        return this.search.codePointAt(i2) == 10;
    }

    boolean equalCaseBlind(int c1, int c2) {
        if (c1 == c2) {
            return true;
        }
        for (int v : CaseVariants.getCaseVariants(c2)) {
            if (c1 != v) continue;
            return true;
        }
        return false;
    }

    public State captureState() {
        return new State(this._captureState);
    }

    public void resetState(State state) {
        this._captureState = new State(state);
    }

    public static class State {
        int parenCount;
        int[] startn;
        int[] endn;

        public State() {
            this.parenCount = 0;
            this.startn = new int[3];
            this.startn[2] = -1;
            this.startn[1] = -1;
            this.startn[0] = -1;
            this.endn = new int[3];
            this.endn[2] = -1;
            this.endn[1] = -1;
            this.endn[0] = -1;
        }

        public State(State s) {
            this.parenCount = s.parenCount;
            this.startn = Arrays.copyOf(s.startn, s.startn.length);
            this.endn = Arrays.copyOf(s.endn, s.endn.length);
        }
    }
}

